/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.analysis.CouldNotResolve;
import de.fraunhofer.aisec.cpg.analysis.OutOfBoundsCheck;
import de.fraunhofer.aisec.cpg.analysis.ValueEvaluator;
import de.fraunhofer.aisec.cpg.graph.Component;
import de.fraunhofer.aisec.cpg.graph.ExtensionsKt;
import de.fraunhofer.aisec.cpg.graph.HasBase;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.edges.Edge;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.SubscriptExpression;
import de.fraunhofer.aisec.cpg.processing.IStrategy;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/NullPointerCheck;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "run", "", "result", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "handleHasBase", "node", "Lde/fraunhofer/aisec/cpg/graph/HasBase;", "cpg-console"})
@SourceDebugExtension(value={"SMAP\nNullPointerCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NullPointerCheck.kt\nde/fraunhofer/aisec/cpg/analysis/NullPointerCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1368#2:137\n1454#2,5:138\n1863#2,2:143\n*S KotlinDebug\n*F\n+ 1 NullPointerCheck.kt\nde/fraunhofer/aisec/cpg/analysis/NullPointerCheck\n*L\n50#1:137\n50#1:138,5\n73#1:143,2\n*E\n"})
public final class NullPointerCheck {
    private final Logger getLog() {
        Logger logger = LoggerFactory.getLogger(OutOfBoundsCheck.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    public final void run(@NotNull TranslationResult result) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Iterable $this$flatMap$iv = result.getComponents();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Component it = (Component)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getTranslationUnits();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        for (TranslationUnitDeclaration tu : (List)destination$iv$iv) {
            Strategy strategy = Strategy.INSTANCE;
            tu.accept(new IStrategy(strategy){
                final /* synthetic */ Strategy $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final Iterator<Node> getIterator(Node p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return this.$tmp0.AST_FORWARD(p0);
                }

                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, Strategy.class, "AST_FORWARD", "AST_FORWARD(Lde/fraunhofer/aisec/cpg/graph/Node;)Ljava/util/Iterator;", 0);
                }

                public final boolean equals(Object other) {
                    return other instanceof IStrategy ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                }
            }, (IVisitor)new IVisitor<Node>(this){
                final /* synthetic */ NullPointerCheck this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void visit(MemberCallExpression v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    this.this$0.handleHasBase((HasBase)v);
                }

                public final void visit(MemberExpression v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    this.this$0.handleHasBase((HasBase)v);
                }

                public final void visit(SubscriptExpression v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    this.this$0.handleHasBase((HasBase)v);
                }
            });
        }
    }

    public final void handleHasBase(@NotNull HasBase node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        try {
            Object object = node.getBase();
            if (object != null && (object = object.getPrevDFG()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Node last;
                    String string;
                    Node it = (Node)element$iv;
                    boolean bl = false;
                    Object resolved = new CouldNotResolve();
                    ValueEvaluator resolver = new ValueEvaluator(null, 1, null);
                    if (it instanceof Expression || it instanceof Declaration) {
                        resolved = resolver.evaluate((Object)it);
                    }
                    if (resolved != null) continue;
                    System.out.println((Object)"");
                    AttributedStringBuilder sb = new AttributedStringBuilder();
                    sb.append((CharSequence)"--- FINDING: Null pointer detected in ");
                    sb.append((CharSequence)node.getClass().getSimpleName(), AttributedStyle.DEFAULT.foreground(2));
                    sb.append((CharSequence)" when accessing base ");
                    Expression expression = node.getBase();
                    sb.append((CharSequence)(expression != null ? expression.getName() : null), AttributedStyle.DEFAULT.foreground(3));
                    sb.append((CharSequence)" ---");
                    String header = sb.toAnsi();
                    System.out.println((Object)header);
                    Object object2 = new AttributedString((CharSequence)PhysicalLocation.Companion.locationLink(((Node)node).getLocation()), AttributedStyle.DEFAULT.foreground(12)).toAnsi() + ": " + de.fraunhofer.aisec.cpg.console.ExtensionsKt.fancyCode$default((Node)node, 0, false, 1, null);
                    System.out.println(object2);
                    System.out.println((Object)"");
                    Expression expression2 = node.getBase();
                    object2 = "The following path was discovered that leads to " + new AttributedString((CharSequence)(expression2 != null ? expression2.getName() : null), AttributedStyle.DEFAULT.foreground(3)).toAnsi() + " being null:";
                    System.out.println(object2);
                    for (Node p : resolver.getPath()) {
                        string = new AttributedString((CharSequence)PhysicalLocation.Companion.locationLink(p.getLocation()), AttributedStyle.DEFAULT.foreground(12)).toAnsi() + ": " + de.fraunhofer.aisec.cpg.console.ExtensionsKt.fancyCode$default(p, 0, false, 1, null);
                        System.out.println((Object)string);
                    }
                    List path = ExtensionsKt.followPrevEOG((Node)it, NullPointerCheck::handleHasBase$lambda$2$lambda$1);
                    List list = path;
                    Node node2 = list != null && (list = (Edge)CollectionsKt.last((List)list)) != null ? list.getStart() : (last = null);
                    if (last instanceof IfStatement) {
                        System.out.println();
                        Expression expression3 = ((IfStatement)last).getCondition();
                        string = "Branch depends on " + new AttributedString((CharSequence)"IfStatement", AttributedStyle.DEFAULT.foreground(2)).toAnsi() + " with condition " + new AttributedString((CharSequence)(expression3 != null ? expression3.getCode() : null), AttributedStyle.DEFAULT.foreground(6)).toAnsi() + " in " + de.fraunhofer.aisec.cpg.console.ExtensionsKt.fancyLocationLink(last);
                        System.out.println((Object)string);
                    }
                    System.out.println((Object)StringsKt.repeat((CharSequence)"-", (int)sb.toString().length()));
                }
            }
        }
        catch (Throwable ex) {
            this.getLog().error("Exception while running check", ex);
        }
    }

    private static final boolean handleHasBase$lambda$2$lambda$1(Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        return edge.getStart() instanceof IfStatement || edge.getStart() instanceof FunctionDeclaration;
    }
}

