/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.console;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Block;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.NewArrayExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference;
import de.fraunhofer.aisec.cpg.graph.types.HasType;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.ki.shell.configuration.ReplConfiguration;
import org.jetbrains.kotlinx.ki.shell.configuration.ReplConfigurationBase;
import org.jetbrains.kotlinx.ki.shell.plugins.SyntaxPlugin;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006*\b\u0012\u0004\u0012\u00020\u00010\u00062\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u001a,\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00130\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001\u001a2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00130\u001cH\u0002\u001a:\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00012\u0018\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00130\u001c2\u0006\u0010\u001f\u001a\u00020\u0014H\u0002\u001a\u0016\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f\u001a\f\u0010\"\u001a\u00020\b*\u0004\u0018\u00010\u0001\"\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"printCode", "Lde/fraunhofer/aisec/cpg/graph/Node;", "linesAhead", "", "showNumbers", "", "", "fancyCode", "", "getCode", "file", "region", "Lde/fraunhofer/aisec/cpg/sarif/Region;", "styles", "Lorg/jetbrains/kotlinx/ki/shell/plugins/SyntaxPlugin$HighlightStylesFromConfiguration;", "getStyles", "()Lorg/jetbrains/kotlinx/ki/shell/plugins/SyntaxPlugin$HighlightStylesFromConfiguration;", "getFanciesFor", "", "Lkotlin/Pair;", "Lorg/jline/utils/AttributedStyle;", "original", "node", "fancyType", "", "outer", "Lde/fraunhofer/aisec/cpg/graph/types/HasType;", "list", "", "fancyWord", "word", "style", "getRelativeLocation", "parentRegion", "fancyLocationLink", "cpg-console"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\nde/fraunhofer/aisec/cpg/console/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1#2:346\n1368#3:347\n1454#3,5:348\n1368#3:353\n1454#3,5:354\n1368#3:359\n1454#3,5:360\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\nde/fraunhofer/aisec/cpg/console/ExtensionsKt\n*L\n205#1:347\n205#1:348,5\n217#1:353\n217#1:354,5\n255#1:359\n255#1:360,5\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    private static final SyntaxPlugin.HighlightStylesFromConfiguration styles = new SyntaxPlugin.HighlightStylesFromConfiguration((ReplConfiguration)new ReplConfigurationBase(){});

    @NotNull
    public static final Node printCode(@NotNull Node $this$printCode, int linesAhead, boolean showNumbers) {
        Intrinsics.checkNotNullParameter((Object)$this$printCode, (String)"<this>");
        String header = "--- " + ExtensionsKt.fancyLocationLink($this$printCode) + " ---";
        System.out.println((Object)header);
        System.out.println((Object)ExtensionsKt.fancyCode($this$printCode, linesAhead, showNumbers));
        System.out.println((Object)StringsKt.repeat((CharSequence)"-", (int)header.length()));
        return $this$printCode;
    }

    public static /* synthetic */ Node printCode$default(Node node, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return ExtensionsKt.printCode(node, n, bl);
    }

    @NotNull
    public static final Collection<Node> printCode(@NotNull Collection<? extends Node> $this$printCode, int linesAhead, boolean showNumbers) {
        Intrinsics.checkNotNullParameter($this$printCode, (String)"<this>");
        for (Node next : $this$printCode) {
            ExtensionsKt.printCode(next, linesAhead, showNumbers);
            System.out.println((Object)"");
        }
        return $this$printCode;
    }

    public static /* synthetic */ Collection printCode$default(Collection collection, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return ExtensionsKt.printCode(collection, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String fancyCode(@NotNull Node $this$fancyCode, int linesAhead, boolean showNumbers) {
        Region region;
        Intrinsics.checkNotNullParameter((Object)$this$fancyCode, (String)"<this>");
        String code = null;
        code = $this$fancyCode.getCode();
        PhysicalLocation physicalLocation = $this$fancyCode.getLocation();
        if (physicalLocation != null && (region = physicalLocation.getRegion()) != null) {
            Object object;
            Object file;
            Region it = region;
            boolean bl = false;
            int startLine = it.startLine;
            if (linesAhead != 0) {
                Region region2 = new Region(RangesKt.coerceAtLeast((int)1, (int)(it.startLine - linesAhead)), 1, it.getEndLine(), it.getEndColumn());
                startLine = region2.startLine;
                String string = $this$fancyCode.getFile();
                if (string != null) {
                    file = string;
                    boolean bl2 = false;
                    code = ExtensionsKt.getCode((String)file, region2);
                }
            }
            if ((object = code) == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(file = new String[]{"\n"}), (boolean)false, (int)0, (int)6, null)) == null) {
                object = CollectionsKt.emptyList();
            }
            List lines = CollectionsKt.toMutableList((Collection)((Collection)object));
            Map extraCharsInLines = new LinkedHashMap();
            List<Pair<AttributedStyle, Region>> fancies = ExtensionsKt.getFanciesFor($this$fancyCode, $this$fancyCode);
            for (Pair pair : fancies) {
                String after;
                String before;
                String content;
                Region region3 = ExtensionsKt.getRelativeLocation(it, (Region)pair.getSecond());
                AttributedStyle it2 = (AttributedStyle)pair.getFirst();
                boolean bl3 = false;
                String line = (String)lines.get(region3.startLine);
                int extraCharsInLine = ((Number)extraCharsInLines.getOrDefault(region3.startLine, 0)).intValue();
                Intrinsics.checkNotNullExpressionValue((Object)line.substring(0, region3.startColumn + extraCharsInLine), (String)"substring(...)");
                Intrinsics.checkNotNullExpressionValue((Object)line.substring(region3.startColumn + extraCharsInLine, region3.getEndColumn() + extraCharsInLine), (String)"substring(...)");
                Intrinsics.checkNotNullExpressionValue((Object)line.substring(region3.getEndColumn() + extraCharsInLine), (String)"substring(...)");
                String ansi = new AttributedString((CharSequence)content, (AttributedStyle)pair.getFirst()).toAnsi();
                int extraChars = ansi.length() - content.length();
                lines.set(region3.startLine, before + ansi + after);
                extraCharsInLines.put(region3.startLine, extraCharsInLine += extraChars);
            }
            if (showNumbers) {
                void var11_14;
                Object output = "";
                boolean bl3 = false;
                int n = lines.size();
                while (var11_14 < n) {
                    String line = StringsKt.padStart$default((String)((int)(var11_14 + startLine) + ": "), (int)5, (char)'\u0000', (int)2, null) + lines.get((int)var11_14);
                    if (var11_14 != lines.size() - 1) {
                        line = line + "\n";
                    }
                    output = (String)output + line;
                    ++var11_14;
                }
                return output;
            }
            return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        return $this$fancyCode.getCode();
    }

    public static /* synthetic */ String fancyCode$default(Node node, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ExtensionsKt.fancyCode(node, n, bl);
    }

    @NotNull
    public static final String getCode(@NotNull String file, @NotNull Region region) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Object code = "";
        List lines = FilesKt.readLines$default((File)new File(file), null, (int)1, null);
        int n = region.getEndLine();
        for (int i = region.startLine - 1; i < n; ++i) {
            Object object;
            int n2 = i;
            if (n2 == region.startLine - 1) {
                String string = ((String)lines.get(i)).substring(region.startColumn - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = string + "\n";
            } else if (n2 == region.getEndLine() - 1) {
                String string = ((String)lines.get(i)).substring(0, region.getEndColumn() - 1);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            } else {
                object = lines.get(i) + "\n";
            }
            code = (String)code + (String)object;
        }
        return code;
    }

    @NotNull
    public static final SyntaxPlugin.HighlightStylesFromConfiguration getStyles() {
        return styles;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<AttributedStyle, Region>> getFanciesFor(@Nullable Node original, @Nullable Node node) {
        List list = new ArrayList();
        Node node2 = node;
        if (node2 instanceof MemberExpression) {
            PhysicalLocation physicalLocation = ((MemberExpression)node).getLocation();
            if (physicalLocation != null) {
                PhysicalLocation it = physicalLocation;
                boolean bl = false;
                AttributedStyle attributedStyle = styles.getIdentifier();
                if (attributedStyle != null) {
                    AttributedStyle id = attributedStyle;
                    boolean bl2 = false;
                    ((Collection)list).add(new Pair((Object)id, (Object)it.getRegion()));
                }
            }
            return list;
        }
        if (node2 instanceof Reference) {
            if (Intrinsics.areEqual((Object)original, (Object)node)) {
                PhysicalLocation physicalLocation = ((Reference)node).getLocation();
                if (physicalLocation != null) {
                    PhysicalLocation it = physicalLocation;
                    boolean bl = false;
                    AttributedStyle attributedStyle = styles.getIdentifier();
                    if (attributedStyle != null) {
                        AttributedStyle id = attributedStyle;
                        boolean bl3 = false;
                        ((Collection)list).add(new Pair((Object)id, (Object)it.getRegion()));
                    }
                }
            }
            return list;
        }
        if (node2 instanceof DeclarationStatement) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            if (((DeclarationStatement)node).getSingleDeclaration() instanceof HasType) {
                Declaration declaration = ((DeclarationStatement)node).getSingleDeclaration();
                Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.types.HasType");
                ExtensionsKt.fancyType(node, (HasType)declaration, list);
            }
            Iterable iterable = ((DeclarationStatement)node).getDeclarations();
            List list2 = list;
            boolean $i$f$flatMap = false;
            void it = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Declaration it2 = (Declaration)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ExtensionsKt.getFanciesFor(original, (Node)it2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2.addAll((List)destination$iv$iv);
            return list;
        }
        if (node2 instanceof VariableDeclaration) {
            Expression expression = ((VariableDeclaration)node).getInitializer();
            if (expression != null) {
                Expression it = expression;
                boolean bl = false;
                list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)it));
            }
            return list;
        }
        if (node2 instanceof Block) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((Block)node).getStatements();
            List list3 = list;
            boolean $i$f$flatMap = false;
            Iterable it = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Statement it3 = (Statement)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ExtensionsKt.getFanciesFor(original, (Node)it3);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list3.addAll((List)destination$iv$iv);
            return list;
        }
        if (node2 instanceof IfStatement) {
            ExtensionsKt.fancyWord("if", node, list, styles.getKeyword());
            Statement statement = ((IfStatement)node).getThenStatement();
            if (statement != null) {
                Statement it = statement;
                boolean bl = false;
                list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)it));
            }
            return list;
        }
        if (node2 instanceof BinaryOperator) {
            list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)((BinaryOperator)node).getLhs()));
            list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)((BinaryOperator)node).getRhs()));
        } else {
            if (node2 instanceof Literal) {
                Object $this$flatMap$iv = ((Literal)node).getValue();
                if ($this$flatMap$iv instanceof Number) {
                    PhysicalLocation physicalLocation = ((Literal)node).getLocation();
                    if (physicalLocation != null) {
                        PhysicalLocation it = physicalLocation;
                        boolean bl = false;
                        ((Collection)list).add(new Pair((Object)styles.getNumber(), (Object)it.getRegion()));
                    }
                } else if ($this$flatMap$iv == null) {
                    PhysicalLocation physicalLocation = ((Literal)node).getLocation();
                    if (physicalLocation != null) {
                        PhysicalLocation it = physicalLocation;
                        boolean bl = false;
                        ((Collection)list).add(new Pair((Object)styles.getNumber(), (Object)it.getRegion()));
                    }
                } else if ($this$flatMap$iv instanceof Boolean) {
                    PhysicalLocation physicalLocation = ((Literal)node).getLocation();
                    if (physicalLocation != null) {
                        PhysicalLocation it = physicalLocation;
                        boolean bl = false;
                        ((Collection)list).add(new Pair((Object)styles.getNumber(), (Object)it.getRegion()));
                    }
                } else if ($this$flatMap$iv instanceof String) {
                    PhysicalLocation physicalLocation = ((Literal)node).getLocation();
                    if (physicalLocation != null) {
                        PhysicalLocation it = physicalLocation;
                        boolean bl = false;
                        ((Collection)list).add(new Pair((Object)styles.getString(), (Object)it.getRegion()));
                    }
                }
                return list;
            }
            if (node2 instanceof NewArrayExpression) {
                void $this$flatMapTo$iv$iv;
                Object it;
                ExtensionsKt.fancyWord("new", node, list, styles.getKeyword());
                for (String primitive : ((NewArrayExpression)node).getLanguage().getPrimitiveTypeNames()) {
                    ExtensionsKt.fancyWord(primitive, node, list, styles.getKeyword());
                }
                Expression expression = ((NewArrayExpression)node).getInitializer();
                if (expression != null) {
                    it = expression;
                    boolean bl = false;
                    list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)it));
                }
                Iterable $this$flatMap$iv = ((NewArrayExpression)node).getDimensions();
                List list4 = list;
                boolean $i$f$flatMap = false;
                it = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Expression it4 = (Expression)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = ExtensionsKt.getFanciesFor(original, (Node)it4);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list4.addAll((List)destination$iv$iv);
                return list;
            }
            if (node2 instanceof FunctionDeclaration) {
                String[] stringArray = new String[]{"public", "private", "static"};
                List keywords = CollectionsKt.listOf((Object[])stringArray);
                for (String keyword : keywords) {
                    ExtensionsKt.fancyWord(keyword, node, list, styles.getKeyword());
                }
                ExtensionsKt.fancyWord(((FunctionDeclaration)node).getName().toString(), node, list, styles.getFunction());
                Statement statement = ((FunctionDeclaration)node).getBody();
                if (statement != null) {
                    Statement it = statement;
                    boolean bl = false;
                    list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)it));
                }
                return list;
            }
        }
        return list;
    }

    private static final void fancyType(Node outer, HasType node, List<Pair<AttributedStyle, Region>> list) {
        Set types = CollectionsKt.toMutableSet((Iterable)outer.getLanguage().getPrimitiveTypeNames());
        ((Collection)types).add(node.getType().getName().toString());
        for (String type : types) {
            ExtensionsKt.fancyWord(type, outer, list, styles.getType());
        }
    }

    private static final void fancyWord(String word, Node node, List<Pair<AttributedStyle, Region>> list, AttributedStyle style) {
        block1: {
            int offset;
            PhysicalLocation physicalLocation = node.getLocation();
            if (physicalLocation == null) break block1;
            PhysicalLocation it = physicalLocation;
            boolean bl = false;
            String string = node.getCode();
            int n = offset = string != null ? StringsKt.indexOf$default((CharSequence)string, (String)word, (int)0, (boolean)false, (int)6, null) : -1;
            if (offset != -1) {
                Region region = new Region(it.getRegion().startLine, it.getRegion().startColumn + offset, it.getRegion().startLine, it.getRegion().startColumn + offset + word.length());
                ((Collection)list).add(new Pair((Object)style, (Object)region));
            }
        }
    }

    @NotNull
    public static final Region getRelativeLocation(@NotNull Region parentRegion, @NotNull Region region) {
        Intrinsics.checkNotNullParameter((Object)parentRegion, (String)"parentRegion");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        int columnOffset = region.startLine == parentRegion.startLine ? parentRegion.startColumn : 1;
        int lineOffset = parentRegion.startLine;
        return new Region(region.startLine - lineOffset, region.startColumn - columnOffset, region.getEndLine() - lineOffset, region.getEndColumn() - columnOffset);
    }

    @NotNull
    public static final String fancyLocationLink(@Nullable Node $this$fancyLocationLink) {
        Node node = $this$fancyLocationLink;
        String string = new AttributedString((CharSequence)PhysicalLocation.Companion.locationLink((PhysicalLocation)(node != null ? node.getLocation() : null)), AttributedStyle.DEFAULT.foreground(12)).toAnsi();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toAnsi(...)");
        return string;
    }
}

