/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.analysis.CouldNotResolve;
import de.fraunhofer.aisec.cpg.analysis.NullPointerCheck;
import de.fraunhofer.aisec.cpg.analysis.OutOfBoundsCheck;
import de.fraunhofer.aisec.cpg.analysis.ValueEvaluator;
import de.fraunhofer.aisec.cpg.graph.ExtensionsKt;
import de.fraunhofer.aisec.cpg.graph.HasBase;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/NullPointerCheck;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "handleHasBase", "", "node", "Lde/fraunhofer/aisec/cpg/graph/HasBase;", "run", "result", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "cpg-console"})
@SourceDebugExtension(value={"SMAP\nNullPointerCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NullPointerCheck.kt\nde/fraunhofer/aisec/cpg/analysis/NullPointerCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1855#2,2:139\n*S KotlinDebug\n*F\n+ 1 NullPointerCheck.kt\nde/fraunhofer/aisec/cpg/analysis/NullPointerCheck\n*L\n75#1:139,2\n*E\n"})
public final class NullPointerCheck {
    private final Logger getLog() {
        Logger logger = LoggerFactory.getLogger(OutOfBoundsCheck.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(OutOfBoundsCheck::class.java)");
        return logger;
    }

    public final void run(@NotNull TranslationResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            tu.accept(Strategy::AST_FORWARD, (IVisitor)new IVisitor<Node>(this){
                final /* synthetic */ NullPointerCheck this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void visit(@NotNull MemberCallExpression v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    this.this$0.handleHasBase((HasBase)v);
                }

                public final void visit(@NotNull MemberExpression v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    this.this$0.handleHasBase((HasBase)v);
                }

                public final void visit(@NotNull ArraySubscriptionExpression v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    this.this$0.handleHasBase((HasBase)v);
                }
            });
        }
    }

    public final void handleHasBase(@NotNull HasBase node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        try {
            Object object = node.getBase();
            if (object != null && (object = object.getPrevDFG()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Node last;
                    String string;
                    Node it = (Node)element$iv;
                    boolean bl = false;
                    Object resolved = new CouldNotResolve();
                    ValueEvaluator resolver = new ValueEvaluator(null, 1, null);
                    if (it instanceof Expression || it instanceof Declaration) {
                        resolved = resolver.evaluate((Object)it);
                    }
                    if (resolved != null) continue;
                    System.out.println((Object)"");
                    AttributedStringBuilder sb = new AttributedStringBuilder();
                    sb.append((CharSequence)"--- FINDING: Null pointer detected in ");
                    sb.append((CharSequence)node.getClass().getSimpleName(), AttributedStyle.DEFAULT.foreground(2));
                    sb.append((CharSequence)" when accessing base ");
                    Expression expression = node.getBase();
                    sb.append((CharSequence)(expression != null ? expression.getName() : null), AttributedStyle.DEFAULT.foreground(3));
                    sb.append((CharSequence)" ---");
                    String header = sb.toAnsi();
                    System.out.println((Object)header);
                    Object object2 = new AttributedString((CharSequence)PhysicalLocation.locationLink((PhysicalLocation)((Node)node).getLocation()), AttributedStyle.DEFAULT.foreground(12)).toAnsi() + ": " + de.fraunhofer.aisec.cpg.console.ExtensionsKt.fancyCode$default((Node)node, 0, false, 1, null);
                    System.out.println(object2);
                    System.out.println((Object)"");
                    Expression expression2 = node.getBase();
                    object2 = "The following path was discovered that leads to " + new AttributedString((CharSequence)(expression2 != null ? expression2.getName() : null), AttributedStyle.DEFAULT.foreground(3)).toAnsi() + " being null:";
                    System.out.println(object2);
                    for (Node p : resolver.getPath()) {
                        string = new AttributedString((CharSequence)PhysicalLocation.locationLink((PhysicalLocation)p.getLocation()), AttributedStyle.DEFAULT.foreground(12)).toAnsi() + ": " + de.fraunhofer.aisec.cpg.console.ExtensionsKt.fancyCode$default(p, 0, false, 1, null);
                        System.out.println((Object)string);
                    }
                    List path2 = ExtensionsKt.followPrevEOG((Node)it, (Function1)handleHasBase.1.path.1.INSTANCE);
                    List list = path2;
                    Node node2 = list != null && (list = (PropertyEdge)CollectionsKt.last((List)list)) != null ? list.getStart() : (last = null);
                    if (last instanceof IfStatement) {
                        System.out.println();
                        Expression expression3 = ((IfStatement)last).getCondition();
                        string = "Branch depends on " + new AttributedString((CharSequence)"IfStatement", AttributedStyle.DEFAULT.foreground(2)).toAnsi() + " with condition " + new AttributedString((CharSequence)(expression3 != null ? expression3.getCode() : null), AttributedStyle.DEFAULT.foreground(6)).toAnsi() + " in " + de.fraunhofer.aisec.cpg.console.ExtensionsKt.fancyLocationLink(last);
                        System.out.println((Object)string);
                    }
                    System.out.println((Object)StringsKt.repeat((CharSequence)"-", (int)sb.toString().length()));
                }
            }
        }
        catch (Throwable ex) {
            this.getLog().error("Exception while running check: {}", ex);
        }
    }
}

