/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.console.ExtensionsKt;
import de.fraunhofer.aisec.cpg.graph.EvaluateExtensionsKt;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ValueEvaluator;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/OutOfBoundsCheck;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "run", "", "result", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "cpg-console"})
public final class OutOfBoundsCheck {
    private final Logger getLog() {
        Logger logger = LoggerFactory.getLogger(OutOfBoundsCheck.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(OutOfBoundsCheck::class.java)");
        return logger;
    }

    public final void run(@NotNull TranslationResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            tu.accept(Strategy::AST_FORWARD, (IVisitor)new IVisitor<Node>(){

                public final void visit(@NotNull ArraySubscriptionExpression v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    ValueEvaluator evaluator = new ValueEvaluator(null, 1, null);
                    Object resolvedIndex = evaluator.evaluate((Node)v.getSubscriptExpression());
                    if (resolvedIndex instanceof Integer) {
                        VariableDeclaration decl;
                        Expression expression = v.getArrayExpression();
                        DeclaredReferenceExpression declaredReferenceExpression = expression instanceof DeclaredReferenceExpression ? (DeclaredReferenceExpression)expression : null;
                        Declaration declaration = declaredReferenceExpression != null ? declaredReferenceExpression.getRefersTo() : null;
                        VariableDeclaration variableDeclaration = decl = declaration instanceof VariableDeclaration ? (VariableDeclaration)declaration : null;
                        Expression expression2 = variableDeclaration != null ? variableDeclaration.getInitializer() : null;
                        ArrayCreationExpression arrayCreationExpression = expression2 instanceof ArrayCreationExpression ? (ArrayCreationExpression)expression2 : null;
                        if (arrayCreationExpression != null) {
                            ArrayCreationExpression it = arrayCreationExpression;
                            boolean bl = false;
                            int capacity = EvaluateExtensionsKt.getCapacity((ArrayCreationExpression)it);
                            if (((Number)resolvedIndex).intValue() >= capacity) {
                                System.out.println((Object)"");
                                AttributedStringBuilder sb = new AttributedStringBuilder();
                                sb.append((CharSequence)"--- FINDING: Out of bounds access in ");
                                sb.append((CharSequence)it.getClass().getSimpleName(), AttributedStyle.DEFAULT.foreground(2));
                                sb.append((CharSequence)(" when accessing index " + new AttributedString((CharSequence)("" + resolvedIndex), AttributedStyle.DEFAULT.foreground(6)).toAnsi() + " of "));
                                sb.append((CharSequence)decl.getName(), AttributedStyle.DEFAULT.foreground(3));
                                sb.append((CharSequence)(", an array of length " + new AttributedString((CharSequence)("" + capacity), AttributedStyle.DEFAULT.foreground(6)).toAnsi() + " ---"));
                                String header = sb.toAnsi();
                                System.out.println((Object)header);
                                Object object = new AttributedString((CharSequence)PhysicalLocation.locationLink((PhysicalLocation)v.getLocation()), AttributedStyle.DEFAULT.foreground(12)).toAnsi() + ": " + ExtensionsKt.fancyCode$default((Node)v, 0, false, 1, null);
                                System.out.println(object);
                                System.out.println((Object)"");
                                StringBuilder stringBuilder = new StringBuilder().append("The following path was discovered that leads to ");
                                Expression expression3 = v.getSubscriptExpression();
                                Intrinsics.checkNotNullExpressionValue((Object)expression3, (String)"v.subscriptExpression");
                                object = stringBuilder.append(ExtensionsKt.fancyCode$default((Node)expression3, 0, false, 1, null)).append(" being ").append(new AttributedString((CharSequence)("" + resolvedIndex), AttributedStyle.DEFAULT.foreground(6)).toAnsi()).append(':').toString();
                                System.out.println(object);
                                for (Node p : evaluator.getPath()) {
                                    String string = new AttributedString((CharSequence)PhysicalLocation.locationLink((PhysicalLocation)p.getLocation()), AttributedStyle.DEFAULT.foreground(12)).toAnsi() + ": " + ExtensionsKt.fancyCode$default(p, 0, false, 1, null);
                                    System.out.println((Object)string);
                                }
                            }
                        }
                    } else {
                        System.out.println((Object)("Could not resolved " + v.getSubscriptExpression()));
                    }
                }
            });
        }
    }
}

