/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.console;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.ki.shell.configuration.ReplConfiguration;
import org.jetbrains.kotlinx.ki.shell.configuration.ReplConfigurationBase;
import org.jetbrains.kotlinx.ki.shell.plugins.SyntaxPlugin;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u001a2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000bH\u0002\u001a:\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00072\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000b2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000e\u001a(\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u0016\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e\u001a\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u0011*\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\f\u0010 \u001a\u00020\u0011*\u0004\u0018\u00010\u0007\u001a\u001e\u0010!\u001a\u00020\u0007*\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u001a*\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\"*\b\u0012\u0004\u0012\u00020\u00070\"2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006#"}, d2={"styles", "Lorg/jetbrains/kotlinx/ki/shell/plugins/SyntaxPlugin$HighlightStylesFromConfiguration;", "getStyles", "()Lorg/jetbrains/kotlinx/ki/shell/plugins/SyntaxPlugin$HighlightStylesFromConfiguration;", "fancyType", "", "outer", "Lde/fraunhofer/aisec/cpg/graph/Node;", "node", "Lde/fraunhofer/aisec/cpg/graph/HasType;", "list", "", "Lkotlin/Pair;", "Lorg/jline/utils/AttributedStyle;", "Lde/fraunhofer/aisec/cpg/sarif/Region;", "fancyWord", "word", "", "style", "getCode", "file", "region", "getFanciesFor", "", "original", "getRelativeLocation", "parentRegion", "fancyCode", "linesAhead", "", "showNumbers", "", "fancyLocationLink", "printCode", "", "cpg-console"})
public final class ExtensionsKt {
    @NotNull
    private static final SyntaxPlugin.HighlightStylesFromConfiguration styles = new SyntaxPlugin.HighlightStylesFromConfiguration((ReplConfiguration)new ReplConfigurationBase(){});

    @NotNull
    public static final Node printCode(@NotNull Node $this$printCode, int linesAhead, boolean showNumbers) {
        Intrinsics.checkNotNullParameter((Object)$this$printCode, (String)"<this>");
        String header = "--- " + ExtensionsKt.fancyLocationLink($this$printCode) + " ---";
        System.out.println((Object)header);
        System.out.println((Object)ExtensionsKt.fancyCode($this$printCode, linesAhead, showNumbers));
        System.out.println((Object)StringsKt.repeat((CharSequence)"-", (int)header.length()));
        return $this$printCode;
    }

    public static /* synthetic */ Node printCode$default(Node node, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return ExtensionsKt.printCode(node, n, bl);
    }

    @NotNull
    public static final Collection<Node> printCode(@NotNull Collection<? extends Node> $this$printCode, int linesAhead, boolean showNumbers) {
        Intrinsics.checkNotNullParameter($this$printCode, (String)"<this>");
        for (Node next : $this$printCode) {
            ExtensionsKt.printCode(next, linesAhead, showNumbers);
            System.out.println((Object)"");
        }
        return $this$printCode;
    }

    public static /* synthetic */ Collection printCode$default(Collection collection, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return ExtensionsKt.printCode(collection, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String fancyCode(@NotNull Node $this$fancyCode, int linesAhead, boolean showNumbers) {
        Region region;
        Intrinsics.checkNotNullParameter((Object)$this$fancyCode, (String)"<this>");
        String code = null;
        code = $this$fancyCode.getCode();
        PhysicalLocation physicalLocation = $this$fancyCode.getLocation();
        if (physicalLocation != null && (region = physicalLocation.getRegion()) != null) {
            Object object;
            Object file;
            Region it = region;
            boolean bl = false;
            int startLine = it.getStartLine();
            if (linesAhead != 0) {
                Region region2 = new Region(RangesKt.coerceAtLeast((int)1, (int)(it.getStartLine() - linesAhead)), 1, it.getEndLine(), it.getEndColumn());
                startLine = region2.getStartLine();
                String string = $this$fancyCode.getFile();
                if (string != null) {
                    file = string;
                    boolean bl2 = false;
                    code = ExtensionsKt.getCode((String)file, region2);
                }
            }
            if ((object = code) == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(file = new String[]{"\n"}), (boolean)false, (int)0, (int)6, null)) == null) {
                object = CollectionsKt.emptyList();
            }
            List lines = CollectionsKt.toMutableList((Collection)((Collection)object));
            Map extraCharsInLines = new LinkedHashMap();
            List<Pair<AttributedStyle, Region>> fancies = ExtensionsKt.getFanciesFor($this$fancyCode, $this$fancyCode);
            for (Pair pair : fancies) {
                String after;
                String before;
                String content;
                Region region3 = ExtensionsKt.getRelativeLocation(it, (Region)pair.getSecond());
                AttributedStyle it2 = (AttributedStyle)pair.getFirst();
                boolean bl3 = false;
                String line = (String)lines.get(region3.getStartLine());
                int extraCharsInLine = ((Number)extraCharsInLines.getOrDefault(region3.getStartLine(), 0)).intValue();
                Intrinsics.checkNotNullExpressionValue((Object)line.substring(0, region3.getStartColumn() + extraCharsInLine), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Intrinsics.checkNotNullExpressionValue((Object)line.substring(region3.getStartColumn() + extraCharsInLine, region3.getEndColumn() + extraCharsInLine), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Intrinsics.checkNotNullExpressionValue((Object)line.substring(region3.getEndColumn() + extraCharsInLine), (String)"this as java.lang.String).substring(startIndex)");
                String ansi = new AttributedString((CharSequence)content, (AttributedStyle)pair.getFirst()).toAnsi();
                int extraChars = ansi.length() - content.length();
                lines.set(region3.getStartLine(), before + ansi + after);
                extraCharsInLines.put(region3.getStartLine(), extraCharsInLine += extraChars);
            }
            if (showNumbers) {
                void var11_14;
                String output = "";
                boolean bl3 = false;
                int n = lines.size();
                while (var11_14 < n) {
                    String line = StringsKt.padStart$default((String)((int)(var11_14 + startLine) + ": "), (int)5, (char)'\u0000', (int)2, null) + (String)lines.get((int)var11_14);
                    if (var11_14 != lines.size() - 1) {
                        line = line + '\n';
                    }
                    output = output + line;
                    ++var11_14;
                }
                return output;
            }
            return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        return $this$fancyCode.getCode();
    }

    public static /* synthetic */ String fancyCode$default(Node node, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ExtensionsKt.fancyCode(node, n, bl);
    }

    @NotNull
    public static final String getCode(@NotNull String file, @NotNull Region region) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        String code = "";
        List lines = FilesKt.readLines$default((File)new File(file), null, (int)1, null);
        int n = region.getEndLine();
        for (int i = region.getStartLine() - 1; i < n; ++i) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append(code);
            int n2 = i;
            if (n2 == region.getStartLine() - 1) {
                StringBuilder stringBuilder2 = new StringBuilder();
                String string2 = ((String)lines.get(i)).substring(region.getStartColumn() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                string = stringBuilder2.append(string2).append('\n').toString();
            } else if (n2 == region.getEndLine() - 1) {
                String string3 = ((String)lines.get(i)).substring(0, region.getEndColumn() - 1);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string = (String)lines.get(i) + '\n';
            }
            code = stringBuilder.append(string).toString();
        }
        return code;
    }

    @NotNull
    public static final SyntaxPlugin.HighlightStylesFromConfiguration getStyles() {
        return styles;
    }

    @NotNull
    public static final List<Pair<AttributedStyle, Region>> getFanciesFor(@NotNull Node original, @NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List list = new ArrayList();
        Node node2 = node;
        if (node2 instanceof MemberCallExpression) {
            Node node3 = ((MemberCallExpression)node).getMember();
            Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"node.member");
            list.addAll((Collection)ExtensionsKt.getFanciesFor(node, node3));
            return list;
        }
        if (node2 instanceof DeclaredReferenceExpression) {
            PhysicalLocation it;
            MemberCallExpression memberCallExpression = original instanceof MemberCallExpression ? (MemberCallExpression)original : null;
            if (Intrinsics.areEqual((Object)(memberCallExpression != null ? memberCallExpression.getMember() : null), (Object)node)) {
                PhysicalLocation physicalLocation = node.getLocation();
                if (physicalLocation != null) {
                    it = physicalLocation;
                    boolean bl = false;
                    Collection collection = list;
                    AttributedStyle attributedStyle = styles.getIdentifier();
                    Intrinsics.checkNotNull((Object)attributedStyle);
                    collection.add(new Pair((Object)attributedStyle, (Object)it.getRegion()));
                }
            }
            if (Intrinsics.areEqual((Object)original, (Object)node)) {
                PhysicalLocation physicalLocation = node.getLocation();
                if (physicalLocation != null) {
                    it = physicalLocation;
                    boolean bl = false;
                    Collection collection = list;
                    AttributedStyle attributedStyle = styles.getIdentifier();
                    Intrinsics.checkNotNull((Object)attributedStyle);
                    collection.add(new Pair((Object)attributedStyle, (Object)it.getRegion()));
                }
            }
            return list;
        }
        if (node2 instanceof DeclarationStatement) {
            Declaration declaration = ((DeclarationStatement)node).getSingleDeclaration();
            HasType hasType = declaration instanceof HasType ? (HasType)declaration : null;
            Intrinsics.checkNotNull((Object)hasType);
            ExtensionsKt.fancyType(node, hasType, list);
            for (Declaration declaration2 : ((DeclarationStatement)node).getDeclarations()) {
                Intrinsics.checkNotNullExpressionValue((Object)declaration2, (String)"declaration");
                list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)declaration2));
            }
            return list;
        }
        if (node2 instanceof VariableDeclaration) {
            Expression expression = ((VariableDeclaration)node).getInitializer();
            if (expression != null) {
                Expression it = expression;
                boolean bl = false;
                list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)it));
            }
            return list;
        }
        if (node2 instanceof CompoundStatement) {
            for (Statement statement : ((CompoundStatement)node).getStatements()) {
                Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"statement");
                list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)statement));
            }
            return list;
        }
        if (node2 instanceof IfStatement) {
            ExtensionsKt.fancyWord("if", node, list, styles.getKeyword());
            Statement statement = ((IfStatement)node).getThenStatement();
            Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"node.thenStatement");
            list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)statement));
            return list;
        }
        if (node2 instanceof BinaryOperator) {
            Expression expression = ((BinaryOperator)node).getLhs();
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.lhs");
            list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)expression));
            Expression expression2 = ((BinaryOperator)node).getRhs();
            Intrinsics.checkNotNullExpressionValue((Object)expression2, (String)"node.rhs");
            list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)expression2));
        } else {
            if (node2 instanceof Literal) {
                Object object = ((Literal)node).getValue();
                if (object instanceof Number) {
                    PhysicalLocation physicalLocation = node.getLocation();
                    if (physicalLocation != null) {
                        PhysicalLocation it = physicalLocation;
                        boolean bl = false;
                        ((Collection)list).add(new Pair((Object)styles.getNumber(), (Object)it.getRegion()));
                    }
                } else if (object == null) {
                    PhysicalLocation physicalLocation = node.getLocation();
                    if (physicalLocation != null) {
                        PhysicalLocation it = physicalLocation;
                        boolean bl = false;
                        ((Collection)list).add(new Pair((Object)styles.getNumber(), (Object)it.getRegion()));
                    }
                } else if (object instanceof Boolean) {
                    PhysicalLocation physicalLocation = node.getLocation();
                    if (physicalLocation != null) {
                        PhysicalLocation it = physicalLocation;
                        boolean bl = false;
                        ((Collection)list).add(new Pair((Object)styles.getNumber(), (Object)it.getRegion()));
                    }
                } else if (object instanceof String) {
                    PhysicalLocation physicalLocation = node.getLocation();
                    if (physicalLocation != null) {
                        PhysicalLocation it = physicalLocation;
                        boolean bl = false;
                        ((Collection)list).add(new Pair((Object)styles.getString(), (Object)it.getRegion()));
                    }
                }
                return list;
            }
            if (node2 instanceof ArrayCreationExpression) {
                ExtensionsKt.fancyWord("new", node, list, styles.getKeyword());
                for (String primitive : TypeParser.PRIMITIVES) {
                    Intrinsics.checkNotNullExpressionValue((Object)primitive, (String)"primitive");
                    ExtensionsKt.fancyWord(primitive, node, list, styles.getKeyword());
                }
                Expression expression = ((ArrayCreationExpression)node).getInitializer();
                if (expression != null) {
                    Expression it = expression;
                    boolean bl = false;
                    list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)it));
                }
                for (Expression dimension : ((ArrayCreationExpression)node).getDimensions()) {
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"dimension");
                    list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)dimension));
                }
                return list;
            }
            if (node2 instanceof FunctionDeclaration) {
                String[] stringArray = new String[]{"public", "private", "static"};
                List keywords = CollectionsKt.listOf((Object[])stringArray);
                for (String keyword : keywords) {
                    ExtensionsKt.fancyWord(keyword, node, list, styles.getKeyword());
                }
                ExtensionsKt.fancyWord(node.getName(), node, list, styles.getFunction());
                Statement statement = ((FunctionDeclaration)node).getBody();
                Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"node.body");
                list.addAll((Collection)ExtensionsKt.getFanciesFor(original, (Node)statement));
                return list;
            }
        }
        return list;
    }

    private static final void fancyType(Node outer, HasType node, List<Pair<AttributedStyle, Region>> list) {
        List list2 = TypeParser.PRIMITIVES;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"PRIMITIVES");
        Set types = CollectionsKt.toMutableSet((Iterable)list2);
        ((Collection)types).add(node.getType().getName());
        for (String type : types) {
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            ExtensionsKt.fancyWord(type, outer, list, styles.getType());
        }
    }

    private static final void fancyWord(String word, Node node, List<Pair<AttributedStyle, Region>> list, AttributedStyle style) {
        block1: {
            int offset;
            PhysicalLocation physicalLocation = node.getLocation();
            if (physicalLocation == null) break block1;
            PhysicalLocation it = physicalLocation;
            boolean bl = false;
            String string = node.getCode();
            int n = offset = string != null ? StringsKt.indexOf$default((CharSequence)string, (String)word, (int)0, (boolean)false, (int)6, null) : -1;
            if (offset != -1) {
                Region region = new Region(it.getRegion().getStartLine(), it.getRegion().getStartColumn() + offset, it.getRegion().getStartLine(), it.getRegion().getStartColumn() + offset + word.length());
                ((Collection)list).add(new Pair((Object)style, (Object)region));
            }
        }
    }

    @NotNull
    public static final Region getRelativeLocation(@NotNull Region parentRegion, @NotNull Region region) {
        Intrinsics.checkNotNullParameter((Object)parentRegion, (String)"parentRegion");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        int columnOffset = region.getStartLine() == parentRegion.getStartLine() ? parentRegion.getStartColumn() : 1;
        int lineOffset = parentRegion.getStartLine();
        return new Region(region.getStartLine() - lineOffset, region.getStartColumn() - columnOffset, region.getEndLine() - lineOffset, region.getEndColumn() - columnOffset);
    }

    @NotNull
    public static final String fancyLocationLink(@Nullable Node $this$fancyLocationLink) {
        Node node = $this$fancyLocationLink;
        String string = new AttributedString((CharSequence)PhysicalLocation.locationLink((PhysicalLocation)(node != null ? node.getLocation() : null)), AttributedStyle.DEFAULT.foreground(12)).toAnsi();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AttributedString(\n      \u2026      )\n        .toAnsi()");
        return string;
    }
}

