/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.console.ExtensionsKt;
import de.fraunhofer.aisec.cpg.evaluation.ValueEvaluator;
import de.fraunhofer.aisec.cpg.graph.Component;
import de.fraunhofer.aisec.cpg.graph.EvaluationExtensionsKt;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.NewArrayExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.SubscriptExpression;
import de.fraunhofer.aisec.cpg.processing.IStrategy;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/OutOfBoundsCheck;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "run", "", "result", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "cpg-console"})
@SourceDebugExtension(value={"SMAP\nOutOfBoundsCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutOfBoundsCheck.kt\nde/fraunhofer/aisec/cpg/analysis/OutOfBoundsCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1368#2:122\n1454#2,5:123\n*S KotlinDebug\n*F\n+ 1 OutOfBoundsCheck.kt\nde/fraunhofer/aisec/cpg/analysis/OutOfBoundsCheck\n*L\n52#1:122\n52#1:123,5\n*E\n"})
public final class OutOfBoundsCheck {
    private final Logger getLog() {
        Logger logger = LoggerFactory.getLogger(OutOfBoundsCheck.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    public final void run(@NotNull TranslationResult result) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Iterable $this$flatMap$iv = result.getComponents();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Component it = (Component)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getTranslationUnits();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        for (TranslationUnitDeclaration tu : (List)destination$iv$iv) {
            Strategy strategy = Strategy.INSTANCE;
            tu.accept(new IStrategy(strategy){
                final /* synthetic */ Strategy $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final Iterator<Node> getIterator(Node p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return this.$tmp0.AST_FORWARD(p0);
                }

                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, Strategy.class, "AST_FORWARD", "AST_FORWARD(Lde/fraunhofer/aisec/cpg/graph/Node;)Ljava/util/Iterator;", 0);
                }

                public final boolean equals(Object other) {
                    return other instanceof IStrategy ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                }
            }, (IVisitor)new IVisitor<Node>(){

                public final void visit(SubscriptExpression v) {
                    block3: {
                        VariableDeclaration decl;
                        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                        ValueEvaluator evaluator = v.getLanguage().getEvaluator();
                        Object resolvedIndex = evaluator.evaluate((Object)v.getSubscriptExpression());
                        if (!(resolvedIndex instanceof Integer)) {
                            System.out.println((Object)("Could not resolve " + v.getSubscriptExpression()));
                            return;
                        }
                        Expression expression = v.getArrayExpression();
                        Reference reference = expression instanceof Reference ? (Reference)expression : null;
                        Declaration declaration = reference != null ? reference.getRefersTo() : null;
                        VariableDeclaration variableDeclaration = decl = declaration instanceof VariableDeclaration ? (VariableDeclaration)declaration : null;
                        Expression expression2 = variableDeclaration != null ? variableDeclaration.getInitializer() : null;
                        NewArrayExpression newArrayExpression = expression2 instanceof NewArrayExpression ? (NewArrayExpression)expression2 : null;
                        if (newArrayExpression == null) break block3;
                        NewArrayExpression it = newArrayExpression;
                        boolean bl = false;
                        int capacity = EvaluationExtensionsKt.getCapacity((NewArrayExpression)it);
                        if (((Number)resolvedIndex).intValue() >= capacity) {
                            System.out.println((Object)"");
                            AttributedStringBuilder sb = new AttributedStringBuilder();
                            sb.append((CharSequence)"--- FINDING: Out of bounds access in ");
                            sb.append((CharSequence)it.getClass().getSimpleName(), AttributedStyle.DEFAULT.foreground(2));
                            sb.append((CharSequence)(" when accessing index " + new AttributedString((CharSequence)("" + resolvedIndex), AttributedStyle.DEFAULT.foreground(6)).toAnsi() + " of "));
                            sb.append((CharSequence)decl.getName(), AttributedStyle.DEFAULT.foreground(3));
                            sb.append((CharSequence)(", an array of length " + new AttributedString((CharSequence)("" + capacity), AttributedStyle.DEFAULT.foreground(6)).toAnsi() + " ---"));
                            String header = sb.toAnsi();
                            System.out.println((Object)header);
                            Object object = new AttributedString((CharSequence)PhysicalLocation.Companion.locationLink(v.getLocation()), AttributedStyle.DEFAULT.foreground(12)).toAnsi() + ": " + ExtensionsKt.fancyCode$default((Node)v, 0, false, 1, null);
                            System.out.println(object);
                            System.out.println((Object)"");
                            object = "The following path was discovered that leads to " + ExtensionsKt.fancyCode$default((Node)v.getSubscriptExpression(), 0, false, 1, null) + " being " + new AttributedString((CharSequence)("" + resolvedIndex), AttributedStyle.DEFAULT.foreground(6)).toAnsi() + ":";
                            System.out.println(object);
                            for (Node p : evaluator.getPath()) {
                                String string = new AttributedString((CharSequence)PhysicalLocation.Companion.locationLink(p.getLocation()), AttributedStyle.DEFAULT.foreground(12)).toAnsi() + ": " + ExtensionsKt.fancyCode$default(p, 0, false, 1, null);
                                System.out.println((Object)string);
                            }
                        }
                    }
                }
            });
        }
    }
}

