/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis;

import de.fraunhofer.aisec.cpg.analysis.NumberSet;
import de.fraunhofer.aisec.cpg.graph.Node;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0018"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/ConcreteNumberSet;", "Lde/fraunhofer/aisec/cpg/analysis/NumberSet;", "values", "", "", "(Ljava/util/Set;)V", "getValues", "()Ljava/util/Set;", "setValues", "addValue", "", "value", "clear", "equals", "", "other", "", "hashCode", "", "max", "maybe", "min", "toString", "", "cpg-analysis"})
public final class ConcreteNumberSet
implements NumberSet {
    @NotNull
    private Set<Long> values;

    public ConcreteNumberSet(@NotNull Set<Long> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.values = values;
    }

    public /* synthetic */ ConcreteNumberSet(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new LinkedHashSet();
        }
        this(set);
    }

    @NotNull
    public final Set<Long> getValues() {
        return this.values;
    }

    public final void setValues(@NotNull Set<Long> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.values = set;
    }

    @Override
    public void addValue(long value) {
        this.values.add(value);
    }

    @Override
    public long min() {
        Long l = (Long)CollectionsKt.minOrNull((Iterable)this.values);
        return l != null ? l : Long.MAX_VALUE;
    }

    @Override
    public long max() {
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)this.values);
        return l != null ? l : Long.MIN_VALUE;
    }

    @Override
    public boolean maybe(long value) {
        return this.values.contains(value);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.analysis.ConcreteNumberSet");
        ConcreteNumberSet cfr_ignored_0 = (ConcreteNumberSet)other;
        return Intrinsics.areEqual(this.values, ((ConcreteNumberSet)other).values);
    }

    public int hashCode() {
        return ((Object)this.values).hashCode();
    }

    @NotNull
    public String toString() {
        String string = new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).append(this.values).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public ConcreteNumberSet() {
        this(null, 1, null);
    }
}

