/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.query;

import de.fraunhofer.aisec.cpg.analysis.ValueEvaluatorKt;
import de.fraunhofer.aisec.cpg.query.QueryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0002B+\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00002\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0000H\u0086\u0004J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00002\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0086\u0004J!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00002\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0000H\u0086\u0004J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00002\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0086\u0004J\u0017\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0096\u0002J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u001cH\u0086\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u00002\u0006\u0010\u0016\u001a\u00028\u0000H\u0086\u0004\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0004J\u0013\u0010\u001f\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\u001bH\u0016J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u00002\u0006\u0010\u0016\u001a\u00028\u0000H\u0086\u0004\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0004J\u0010\u0010#\u001a\u00020\u00072\b\b\u0002\u0010$\u001a\u00020\u001bR\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0003\u001a\u00028\u0000X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lde/fraunhofer/aisec/cpg/query/QueryTree;", "T", "", "value", "children", "", "stringRepresentation", "", "(Ljava/lang/Object;Ljava/util/List;Ljava/lang/String;)V", "getChildren", "()Ljava/util/List;", "getStringRepresentation", "()Ljava/lang/String;", "setStringRepresentation", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "IN", "", "other", "", "IS", "Ljava/lang/Class;", "compareTo", "", "", "eq", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/query/QueryTree;", "equals", "", "hashCode", "ne", "printNicely", "depth", "cpg-analysis"})
@SourceDebugExtension(value={"SMAP\nQueryTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryTree.kt\nde/fraunhofer/aisec/cpg/query/QueryTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,301:1\n1855#2,2:302\n*S KotlinDebug\n*F\n+ 1 QueryTree.kt\nde/fraunhofer/aisec/cpg/query/QueryTree\n*L\n70#1:302,2\n*E\n"})
public class QueryTree<T>
implements Comparable<QueryTree<T>> {
    private T value;
    @NotNull
    private final List<QueryTree<?>> children;
    @NotNull
    private String stringRepresentation;

    public QueryTree(T value, @NotNull List<QueryTree<?>> children, @NotNull String stringRepresentation) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)stringRepresentation, (String)"stringRepresentation");
        this.value = value;
        this.children = children;
        this.stringRepresentation = stringRepresentation;
    }

    public /* synthetic */ QueryTree(Object object, List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        if ((n & 4) != 0) {
            string = "";
        }
        this(object, list, string);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T t) {
        this.value = t;
    }

    @NotNull
    public List<QueryTree<?>> getChildren() {
        return this.children;
    }

    @NotNull
    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public void setStringRepresentation(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.stringRepresentation = string;
    }

    @NotNull
    public final String printNicely(int depth) {
        String res = null;
        res = StringsKt.repeat((CharSequence)"  ", (int)depth) + this.getStringRepresentation() + " (==> " + this.getValue() + ")\n" + StringsKt.repeat((CharSequence)"--------", (int)(depth + 1));
        if (!((Collection)this.getChildren()).isEmpty()) {
            res = res + "\n";
            Iterable $this$forEach$iv = this.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                QueryTree c = (QueryTree)element$iv;
                boolean bl = false;
                String next = c.printNicely(depth + 2);
                if (!(((CharSequence)next).length() > 0)) continue;
                res = res + next + "\n" + StringsKt.repeat((CharSequence)"--------", (int)(depth + 1)) + "\n";
            }
        }
        return res;
    }

    public static /* synthetic */ String printNicely$default(QueryTree queryTree, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printNicely");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return queryTree.printNicely(n);
    }

    @NotNull
    public final QueryTree<Boolean> eq(@NotNull QueryTree<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        boolean result = Intrinsics.areEqual(this.getValue(), other.getValue());
        Object[] objectArray = new QueryTree[]{this, other};
        return new QueryTree<Boolean>(result, CollectionsKt.mutableListOf((Object[])objectArray), this.getValue() + " == " + other.getValue());
    }

    @NotNull
    public final QueryTree<Boolean> eq(T other) {
        boolean result = Intrinsics.areEqual(this.getValue(), other);
        Object[] objectArray = new QueryTree[]{this, new QueryTree<T>(other, null, null, 6, null)};
        return new QueryTree<Boolean>(result, CollectionsKt.mutableListOf((Object[])objectArray), this.getValue() + " == " + this.getValue());
    }

    @NotNull
    public final QueryTree<Boolean> ne(@NotNull QueryTree<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        boolean result = !Intrinsics.areEqual(this.getValue(), other.getValue());
        Object[] objectArray = new QueryTree[]{this, other};
        return new QueryTree<Boolean>(result, CollectionsKt.mutableListOf((Object[])objectArray), this.getValue() + " != " + other.getValue());
    }

    @NotNull
    public final QueryTree<Boolean> ne(T other) {
        boolean result = !Intrinsics.areEqual(this.getValue(), other);
        Object[] objectArray = new QueryTree[]{this, new QueryTree<T>(other, null, null, 6, null)};
        return new QueryTree<Boolean>(result, CollectionsKt.mutableListOf((Object[])objectArray), this.getValue() + " != " + this.getValue());
    }

    @NotNull
    public final QueryTree<Boolean> IN(@NotNull QueryTree<Collection<?>> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        boolean result = CollectionsKt.contains((Iterable)other.getValue(), this.getValue());
        Object[] objectArray = new QueryTree[]{this, other};
        return new QueryTree<Boolean>(result, CollectionsKt.mutableListOf((Object[])objectArray), this.getValue() + " in " + other.getValue());
    }

    @NotNull
    public final QueryTree<Boolean> IN(@NotNull Collection<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        boolean result = CollectionsKt.contains((Iterable)other, this.getValue());
        Object[] objectArray = new QueryTree[]{this, new QueryTree<T>(other, null, null, 6, null)};
        return new QueryTree<Boolean>(result, CollectionsKt.mutableListOf((Object[])objectArray), this.getValue() + " in " + other);
    }

    @NotNull
    public final QueryTree<Boolean> IS(@NotNull QueryTree<Class<?>> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        boolean result = other.getValue().isInstance(this.getValue());
        Object[] objectArray = new QueryTree[]{this, other};
        return new QueryTree<Boolean>(result, CollectionsKt.mutableListOf((Object[])objectArray), this.getValue() + " is " + other.getValue());
    }

    @NotNull
    public final QueryTree<Boolean> IS(@NotNull Class<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        boolean result = other.isInstance(this.getValue());
        Object[] objectArray = new QueryTree[]{this, new QueryTree<T>(other, null, null, 6, null)};
        return new QueryTree<Boolean>(result, CollectionsKt.mutableListOf((Object[])objectArray), this.getValue() + " is " + other);
    }

    public int hashCode() {
        T t = this.getValue();
        return t != null ? t.hashCode() : 0;
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof QueryTree) {
            T t = this.getValue();
            return t != null ? t.equals(((QueryTree)other).getValue()) : false;
        }
        return super.equals(other);
    }

    @Override
    public int compareTo(@NotNull QueryTree<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (this.getValue() instanceof Number && other.getValue() instanceof Number) {
            T t = this.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            Number number = (Number)t;
            T t2 = other.getValue();
            Intrinsics.checkNotNull(t2, (String)"null cannot be cast to non-null type kotlin.Number");
            return ValueEvaluatorKt.compareTo(number, (Number)t2);
        }
        if (this.getValue() instanceof Comparable && other.getValue() instanceof Comparable) {
            T t = this.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
            Comparable comparable = (Comparable)t;
            T t3 = other.getValue();
            Intrinsics.checkNotNull(t3, (String)"null cannot be cast to non-null type kotlin.Any");
            return comparable.compareTo(t3);
        }
        throw new QueryException("Cannot compare objects of type " + this.getValue() + " and " + other.getValue());
    }

    @Override
    public final int compareTo(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.getValue() instanceof Number) {
            T t = this.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            return ValueEvaluatorKt.compareTo((Number)t, other);
        }
        throw new QueryException("Cannot compare objects of type " + this.getValue() + " and " + other);
    }
}

