/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis.fsm;

import de.fraunhofer.aisec.cpg.analysis.fsm.Edge;
import de.fraunhofer.aisec.cpg.analysis.fsm.FSMEqualityKt;
import de.fraunhofer.aisec.cpg.analysis.fsm.State;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0015\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0004J\u001a\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016J7\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00042\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J7\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00042\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0000H&J\b\u0010 \u001a\u00020\u0000H\u0016J\u0013\u0010!\u001a\u00020\u00162\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020&R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0001\u0002'(\u00a8\u0006)"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/fsm/FSM;", "", "states", "", "Lde/fraunhofer/aisec/cpg/analysis/fsm/State;", "(Ljava/util/Set;)V", "_states", "", "nextStateName", "", "getNextStateName", "()I", "getStates", "()Ljava/util/Set;", "addEdge", "", "from", "edge", "Lde/fraunhofer/aisec/cpg/analysis/fsm/Edge;", "addState", "state", "isStart", "", "isAcceptingState", "changeStateProperty", "name", "(Lde/fraunhofer/aisec/cpg/analysis/fsm/State;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Boolean;)Z", "checkEdge", "checkState", "checkedChangeStateProperty", "(Lde/fraunhofer/aisec/cpg/analysis/fsm/State;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "copy", "deepCopy", "equals", "other", "renameStatesToBeDifferentFrom", "otherFsm", "toDotString", "", "Lde/fraunhofer/aisec/cpg/analysis/fsm/DFA;", "Lde/fraunhofer/aisec/cpg/analysis/fsm/NFA;", "cpg-analysis"})
@SourceDebugExtension(value={"SMAP\nFSM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FSM.kt\nde/fraunhofer/aisec/cpg/analysis/fsm/FSM\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1774#2,4:198\n661#2,11:203\n1747#2,3:214\n1747#2,3:217\n1855#2,2:220\n661#2,11:222\n1855#2,2:233\n1#3:202\n*S KotlinDebug\n*F\n+ 1 FSM.kt\nde/fraunhofer/aisec/cpg/analysis/fsm/FSM\n*L\n38#1:198,4\n59#1:203,11\n113#1:214,3\n119#1:217,3\n147#1:220,2\n188#1:222,11\n192#1:233,2\n*E\n"})
public abstract class FSM {
    @NotNull
    private final Set<State> _states = new LinkedHashSet();

    private FSM(Set<State> states) {
        int n;
        Iterable $this$count$iv = states;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                State it = (State)element$iv;
                boolean bl = false;
                if (!it.isStart() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (!(n <= 1)) {
            boolean $i$a$-require-FSM$32 = false;
            String $i$a$-require-FSM$32 = "Cannot create a FSM with multiple start states";
            throw new IllegalArgumentException($i$a$-require-FSM$32.toString());
        }
        for (State state : states) {
            this.addState(state);
        }
    }

    @NotNull
    public final Set<State> getStates() {
        return this._states;
    }

    private final int getNextStateName() {
        int n;
        if (this.getStates().isEmpty()) {
            n = 1;
        } else {
            Iterator iterator = ((Iterable)this.getStates()).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            State it = (State)iterator.next();
            boolean bl = false;
            int n2 = it.getName();
            while (iterator.hasNext()) {
                State it2 = (State)iterator.next();
                $i$a$-maxOf-FSM$nextStateName$1 = false;
                int n3 = it2.getName();
                if (n2 >= n3) continue;
                n2 = n3;
            }
            n = n2 + 1;
        }
        return n;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FSM ? FSMEqualityKt.acceptsSameLanguage$default(this, (FSM)other, false, 4, null) : false;
    }

    public void checkEdge(@NotNull State state, @NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
    }

    private final void checkState(State state) {
        for (Edge edge : state.getOutgoingEdges()) {
            this.checkEdge(state, edge);
        }
        if (state.isStart()) {
            Object v0;
            block5: {
                Iterable $this$singleOrNull$iv = this.getStates();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    State it = (State)element$iv;
                    boolean bl = false;
                    if (!it.isStart()) continue;
                    if (found$iv) {
                        v0 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            if (!(v0 == null)) {
                boolean bl = false;
                String string = "This FSM already has a start state.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @NotNull
    public final State addState(boolean isStart, boolean isAcceptingState) {
        State newState = new State(this.getNextStateName(), isStart, isAcceptingState);
        this.addState(newState);
        return newState;
    }

    public static /* synthetic */ State addState$default(FSM fSM, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addState");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return fSM.addState(bl, bl2);
    }

    protected final void addState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.getStates().contains(state)) {
            this.checkState(state);
            state.setEdgeCheck$cpg_analysis((Function1<? super Edge, Unit>)((Function1)new Function1<Edge, Unit>(this, state){
                final /* synthetic */ FSM this$0;
                final /* synthetic */ State $state;
                {
                    this.this$0 = $receiver;
                    this.$state = $state;
                    super(1);
                }

                public final void invoke(@NotNull Edge edge) {
                    Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
                    this.this$0.checkEdge(this.$state, edge);
                }
            }));
            this._states.add(state);
        }
    }

    public final void addEdge(@NotNull State from, @NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        this.addState(from);
        from.addEdge(edge);
        this.addState(edge.getNextState());
    }

    public final boolean changeStateProperty(@NotNull State state, @Nullable Integer name, @Nullable Boolean isStart, @Nullable Boolean isAcceptingState) {
        State it;
        boolean $i$f$any;
        Iterable $this$any$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (name != null) {
            boolean bl;
            block12: {
                $this$any$iv = this.getStates();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (State)element$iv;
                        boolean bl2 = false;
                        Integer n = name;
                        if (!(n != null && it.getName() == n.intValue())) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
            state.setName$cpg_analysis(name);
        }
        if (isStart != null) {
            if (isStart.booleanValue()) {
                boolean bl;
                block13: {
                    $this$any$iv = this.getStates();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (State)element$iv;
                            boolean bl3 = false;
                            if (!it.isStart()) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return false;
                }
            }
            state.setStart$cpg_analysis(isStart);
        }
        if (isAcceptingState != null) {
            state.setAcceptingState$cpg_analysis(isAcceptingState);
        }
        return true;
    }

    public static /* synthetic */ boolean changeStateProperty$default(FSM fSM, State state, Integer n, Boolean bl, Boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: changeStateProperty");
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            bl = null;
        }
        if ((n2 & 8) != 0) {
            bl2 = null;
        }
        return fSM.changeStateProperty(state, n, bl, bl2);
    }

    public final void checkedChangeStateProperty(@NotNull State state, @Nullable Integer name, @Nullable Boolean isStart, @Nullable Boolean isAcceptingState) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.changeStateProperty(state, name, isStart, isAcceptingState)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public static /* synthetic */ void checkedChangeStateProperty$default(FSM fSM, State state, Integer n, Boolean bl, Boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkedChangeStateProperty");
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            bl = null;
        }
        if ((n2 & 8) != 0) {
            bl2 = null;
        }
        fSM.checkedChangeStateProperty(state, n, bl, bl2);
    }

    public final void renameStatesToBeDifferentFrom(@NotNull FSM otherFsm) {
        Intrinsics.checkNotNullParameter((Object)otherFsm, (String)"otherFsm");
        Iterable $this$forEach$iv = otherFsm.getStates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            State it = (State)element$iv;
            boolean bl = false;
            Iterable iterable = this.getStates();
            int n2 = it.getName();
            State state = it;
            FSM fSM = otherFsm;
            Object object = iterable.iterator();
            if (!object.hasNext()) {
                throw new NoSuchElementException();
            }
            State it2 = (State)object.next();
            boolean bl2 = false;
            int n3 = it2.getName();
            while (object.hasNext()) {
                State it222 = (State)object.next();
                $i$a$-maxOf-FSM$renameStatesToBeDifferentFrom$1$1 = false;
                int it222 = it222.getName();
                if (n3 >= it222) continue;
                n3 = it222;
            }
            int n4 = n = n3;
            object = otherFsm.getStates();
            Iterator iterator = object.iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            State it3 = (State)iterator.next();
            boolean bl3 = false;
            int n5 = it3.getName();
            while (iterator.hasNext()) {
                State it4 = (State)iterator.next();
                $i$a$-maxOf-FSM$renameStatesToBeDifferentFrom$1$2 = false;
                int n6 = it4.getName();
                if (n5 >= n6) continue;
                n5 = n6;
            }
            int n7 = n = n5;
            FSM.checkedChangeStateProperty$default(fSM, state, n2 + Math.max(n4, n7), null, null, 12, null);
        }
    }

    @NotNull
    public final String toDotString() {
        Object str = "digraph fsm {\n\t\"\" [shape=point];\n";
        Object edges = "";
        for (State s : this.getStates()) {
            str = (String)str + (s.isAcceptingState() ? "\tq" + s.getName() + " [shape=doublecircle];\n" : "\tq" + s.getName() + " [shape=circle];\n");
            if (s.isStart()) {
                edges = (String)edges + "\t\"\" -> q" + s.getName() + ";\n";
            }
            for (Edge e : s.getOutgoingEdges()) {
                edges = (String)edges + "\tq" + s.getName() + " -> q" + e.getNextState().getName() + " [label=\"" + e.toDotLabel() + "\"];\n";
            }
        }
        return (String)str + (String)edges + "}";
    }

    @NotNull
    public abstract FSM copy();

    @NotNull
    public FSM deepCopy() {
        State startingState;
        Object v0;
        FSM newFSM;
        block5: {
            newFSM = this.copy();
            if (newFSM.getStates().isEmpty()) {
                return newFSM;
            }
            Iterable $this$singleOrNull$iv = this.getStates();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                State it = (State)element$iv;
                boolean bl = false;
                if (!it.isStart()) continue;
                if (found$iv) {
                    v0 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        if ((startingState = (State)v0) == null) {
            boolean $i$a$-checkNotNull-FSM$deepCopy$22 = false;
            String $i$a$-checkNotNull-FSM$deepCopy$22 = "Only FSMs with a single starting state can be deep copied";
            throw new IllegalStateException($i$a$-checkNotNull-FSM$deepCopy$22.toString());
        }
        Set newStates = State.deepCopy$default(startingState, null, 1, null);
        newFSM._states.clear();
        Iterable $this$forEach$iv = newStates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            State it = (State)element$iv;
            boolean bl = false;
            newFSM.addState(it);
        }
        return newFSM;
    }

    public /* synthetic */ FSM(Set states, DefaultConstructorMarker $constructor_marker) {
        this(states);
    }
}

