/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis.fsm;

import de.fraunhofer.aisec.cpg.analysis.fsm.State;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0003J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001a"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/fsm/Edge;", "", "op", "", "base", "nextState", "Lde/fraunhofer/aisec/cpg/analysis/fsm/State;", "(Ljava/lang/String;Ljava/lang/String;Lde/fraunhofer/aisec/cpg/analysis/fsm/State;)V", "getBase", "()Ljava/lang/String;", "getNextState", "()Lde/fraunhofer/aisec/cpg/analysis/fsm/State;", "getOp", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "matches", "edge", "toDotLabel", "toString", "cpg-analysis"})
public final class Edge {
    @NotNull
    private final String op;
    @Nullable
    private final String base;
    @NotNull
    private final State nextState;

    public Edge(@NotNull String op, @Nullable String base, @NotNull State nextState) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)nextState, (String)"nextState");
        this.op = op;
        this.base = base;
        this.nextState = nextState;
    }

    public /* synthetic */ Edge(String string, String string2, State state, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2, state);
    }

    @NotNull
    public final String getOp() {
        return this.op;
    }

    @Nullable
    public final String getBase() {
        return this.base;
    }

    @NotNull
    public final State getNextState() {
        return this.nextState;
    }

    public final boolean matches(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        return Intrinsics.areEqual((Object)this.base, (Object)edge.base) && Intrinsics.areEqual((Object)this.op, (Object)edge.op);
    }

    @NotNull
    public String toString() {
        return this.base != null ? "-- " + this.base + "." + this.op + " --> " + this.nextState : "-- " + this.op + " --> " + this.nextState;
    }

    @NotNull
    public final String toDotLabel() {
        return this.base != null ? this.base + "." + this.op : this.op;
    }

    @NotNull
    public final String component1() {
        return this.op;
    }

    @Nullable
    public final String component2() {
        return this.base;
    }

    @NotNull
    public final State component3() {
        return this.nextState;
    }

    @NotNull
    public final Edge copy(@NotNull String op, @Nullable String base, @NotNull State nextState) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)nextState, (String)"nextState");
        return new Edge(op, base, nextState);
    }

    public static /* synthetic */ Edge copy$default(Edge edge, String string, String string2, State state, int n, Object object) {
        if ((n & 1) != 0) {
            string = edge.op;
        }
        if ((n & 2) != 0) {
            string2 = edge.base;
        }
        if ((n & 4) != 0) {
            state = edge.nextState;
        }
        return edge.copy(string, string2, state);
    }

    public int hashCode() {
        int result = this.op.hashCode();
        result = result * 31 + (this.base == null ? 0 : this.base.hashCode());
        result = result * 31 + this.nextState.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)other;
        if (!Intrinsics.areEqual((Object)this.op, (Object)edge.op)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.base, (Object)edge.base)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.nextState, (Object)edge.nextState);
    }
}

