/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis.fsm;

import de.fraunhofer.aisec.cpg.analysis.fsm.Edge;
import de.fraunhofer.aisec.cpg.analysis.fsm.FSM;
import de.fraunhofer.aisec.cpg.analysis.fsm.NFA;
import de.fraunhofer.aisec.cpg.analysis.fsm.State;
import de.fraunhofer.aisec.cpg.analysis.fsm.Trace;
import de.fraunhofer.aisec.cpg.graph.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0016J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cJ\u001c\u0010\u001d\u001a\u00020\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\u0006\u0010\u001b\u001a\u00020\u001cR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006 "}, d2={"Lde/fraunhofer/aisec/cpg/analysis/fsm/DFA;", "Lde/fraunhofer/aisec/cpg/analysis/fsm/FSM;", "states", "", "Lde/fraunhofer/aisec/cpg/analysis/fsm/State;", "(Ljava/util/Set;)V", "_executionTrace", "", "Lde/fraunhofer/aisec/cpg/analysis/fsm/Trace;", "currentState", "getCurrentState", "()Lde/fraunhofer/aisec/cpg/analysis/fsm/State;", "executionTrace", "", "getExecutionTrace", "()Ljava/util/List;", "isAccepted", "", "()Z", "checkEdge", "", "state", "edge", "Lde/fraunhofer/aisec/cpg/analysis/fsm/Edge;", "copy", "deepCopy", "initializeOrderEvaluation", "cpgNode", "Lde/fraunhofer/aisec/cpg/graph/Node;", "makeTransitionWithOp", "op", "", "cpg-analysis"})
@SourceDebugExtension(value={"SMAP\nDFA.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DFA.kt\nde/fraunhofer/aisec/cpg/analysis/fsm/DFA\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n661#2,11:123\n2624#2,3:135\n661#2,11:138\n766#2:149\n857#2,2:150\n618#2,12:152\n618#2,12:164\n1#3:134\n*S KotlinDebug\n*F\n+ 1 DFA.kt\nde/fraunhofer/aisec/cpg/analysis/fsm/DFA\n*L\n42#1:123,11\n54#1:135,3\n66#1:138,11\n92#1:149\n92#1:150,2\n113#1:152,12\n114#1:164,12\n*E\n"})
public final class DFA
extends FSM {
    @NotNull
    private final List<Trace> _executionTrace;

    public DFA(@NotNull Set<State> states) {
        Intrinsics.checkNotNullParameter(states, (String)"states");
        super(states, null);
        this._executionTrace = new ArrayList();
    }

    public /* synthetic */ DFA(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        this(set);
    }

    @NotNull
    public final List<Trace> getExecutionTrace() {
        return this._executionTrace;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final State getCurrentState() {
        Object object = (Trace)CollectionsKt.lastOrNull(this.getExecutionTrace());
        if (object == null || (object = ((Trace)object).getEdge()) == null || (object = ((Edge)object).getNextState()) == null) {
            Object object2;
            block3: {
                void var3_3;
                Iterable $this$singleOrNull$iv = this.getStates();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    State it = (State)element$iv;
                    boolean bl = false;
                    if (!it.isStart()) continue;
                    if (found$iv) {
                        object2 = null;
                        break block3;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                object2 = !found$iv ? null : var3_3;
            }
            object = (State)object2;
        }
        return object;
    }

    public final boolean isAccepted() {
        State state = this.getCurrentState();
        return state != null ? state.isAcceptingState() : false;
    }

    @Override
    public void checkEdge(@NotNull State state, @NotNull Edge edge) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            if (!(!Intrinsics.areEqual((Object)edge.getOp(), (Object)NFA.Companion.getEPSILON()))) {
                boolean $i$a$-require-DFA$checkEdge$32 = false;
                String $i$a$-require-DFA$checkEdge$32 = "A DFA state must not contain EPSILON edges!";
                throw new IllegalArgumentException($i$a$-require-DFA$checkEdge$32.toString());
            }
            if (!(!Intrinsics.areEqual((Object)edge.getOp(), (Object)""))) {
                boolean $i$a$-require-DFA$checkEdge$52 = false;
                String $i$a$-require-DFA$checkEdge$52 = "The empty String is a reserved op for DFAs.";
                throw new IllegalArgumentException($i$a$-require-DFA$checkEdge$52.toString());
            }
            Iterable $this$none$iv = state.getOutgoingEdges();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Edge e = (Edge)element$iv;
                    boolean bl2 = false;
                    if (!(e.matches(edge) && !Intrinsics.areEqual((Object)e.getNextState(), (Object)edge.getNextState()))) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "State already has an outgoing edge with the same label but a different target!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void initializeOrderEvaluation(@NotNull Node cpgNode) {
        State startState;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)cpgNode, (String)"cpgNode");
            Iterable $this$singleOrNull$iv = this.getStates();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                State it = (State)element$iv;
                boolean bl = false;
                if (!it.isStart()) continue;
                if (found$iv) {
                    v0 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        if ((startState = (State)v0) == null) {
            boolean bl = false;
            String string = "To perform an order evaluation on a DFA, the DFA must have a start state. This DFA does not have a start state.";
            throw new IllegalStateException(string.toString());
        }
        this._executionTrace.clear();
        this._executionTrace.add(new Trace(startState, cpgNode, new Edge("", null, startState, 2, null)));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean makeTransitionWithOp(@NotNull Set<String> op, @NotNull Node cpgNode) {
        boolean bl;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)cpgNode, (String)"cpgNode");
        if (this.getCurrentState() == null) {
            boolean $i$a$-checkNotNull-DFA$makeTransitionWithOp$22 = false;
            String $i$a$-checkNotNull-DFA$makeTransitionWithOp$22 = "Cannot perform a transition because the FSM does not have a starting state!";
            throw new IllegalStateException($i$a$-checkNotNull-DFA$makeTransitionWithOp$22.toString());
        }
        if (!(!((Collection)this.getExecutionTrace()).isEmpty())) {
            boolean $i$a$-check-DFA$makeTransitionWithOp$32 = false;
            String $i$a$-check-DFA$makeTransitionWithOp$32 = "Before performing transitions, you must call [initializeOrderEvaluation] first.";
            throw new IllegalStateException($i$a$-check-DFA$makeTransitionWithOp$32.toString());
        }
        State state = this.getCurrentState();
        Intrinsics.checkNotNull((Object)state);
        Iterable $this$filter$iv = state.getOutgoingEdges();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Edge e = (Edge)element$iv$iv;
            boolean bl2 = false;
            if (!op.contains(e.getOp())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List possibleEdges = (List)destination$iv$iv;
        Edge edgeToFollow = (Edge)CollectionsKt.singleOrNull((List)possibleEdges);
        if (edgeToFollow != null) {
            State state2 = this.getCurrentState();
            Intrinsics.checkNotNull((Object)state2);
            this._executionTrace.add(new Trace(state2, cpgNode, edgeToFollow));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public DFA copy() {
        return new DFA(this.getStates());
    }

    @Override
    @NotNull
    public DFA deepCopy() {
        FSM fSM = super.deepCopy();
        Intrinsics.checkNotNull((Object)fSM, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.analysis.fsm.DFA");
        DFA newDFA = (DFA)fSM;
        for (Trace trace : this.getExecutionTrace()) {
            Iterable $this$single$iv = newDFA.getStates();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                State it = (State)element$iv;
                boolean bl = false;
                if (!(it.getName() == trace.getState().getName())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            State traceState = single$iv;
            Iterable $this$single$iv2 = newDFA.getStates();
            boolean $i$f$single2 = false;
            Object single$iv2 = null;
            boolean found$iv2 = false;
            for (Object element$iv : $this$single$iv2) {
                State it = (State)element$iv;
                boolean bl = false;
                if (!(it.getName() == trace.getEdge().getNextState().getName())) continue;
                if (found$iv2) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv2 = element$iv;
                found$iv2 = true;
            }
            if (!found$iv2) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            State traceNextState = single$iv2;
            newDFA._executionTrace.add(Trace.copy$default(trace, traceState, null, Edge.copy$default(trace.getEdge(), null, null, traceNextState, 3, null), 2, null));
        }
        return newDFA;
    }

    public DFA() {
        this(null, 1, null);
    }
}

