/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis;

import de.fraunhofer.aisec.cpg.analysis.ValueEvaluatorKt;
import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.KeyValueExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J&\u0010\u0010\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bH\u0004J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u001a\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u001a\u0010$\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J&\u0010%\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010&\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010'\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010(\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010)\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010*\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010+\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010,\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010-\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R'\u0010\u0002\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00060"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/ValueEvaluator;", "", "cannotEvaluate", "Lkotlin/Function2;", "Lde/fraunhofer/aisec/cpg/graph/Node;", "(Lkotlin/jvm/functions/Function2;)V", "getCannotEvaluate", "()Lkotlin/jvm/functions/Function2;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "path", "", "getPath", "()Ljava/util/List;", "computeBinaryOpEffect", "lhsValue", "rhsValue", "expr", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/BinaryOperator;", "evaluate", "node", "evaluateInternal", "depth", "", "filterSelfReferences", "", "ref", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/DeclaredReferenceExpression;", "inDFG", "handleArraySubscriptionExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ArraySubscriptionExpression;", "handleBinaryOperator", "handleConditionalExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConditionalExpression;", "handleDeclaredReferenceExpression", "handleDiv", "handleEq", "handleGEq", "handleGreater", "handleLEq", "handleLess", "handleMinus", "handlePlus", "handleTimes", "handleUnaryOp", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/UnaryOperator;", "cpg-analysis"})
@SourceDebugExtension(value={"SMAP\nValueEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueEvaluator.kt\nde/fraunhofer/aisec/cpg/analysis/ValueEvaluator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,499:1\n1#2:500\n288#3,2:501\n766#3:503\n857#3,2:504\n766#3:506\n857#3,2:507\n*S KotlinDebug\n*F\n+ 1 ValueEvaluator.kt\nde/fraunhofer/aisec/cpg/analysis/ValueEvaluator\n*L\n311#1:501,2\n402#1:503\n402#1:504,2\n409#1:506\n409#1:507,2\n*E\n"})
public class ValueEvaluator {
    @NotNull
    private final Function2<Node, ValueEvaluator, Object> cannotEvaluate;
    @NotNull
    private final List<Node> path;

    public ValueEvaluator(@NotNull Function2<? super Node, ? super ValueEvaluator, ? extends Object> cannotEvaluate) {
        Intrinsics.checkNotNullParameter(cannotEvaluate, (String)"cannotEvaluate");
        this.cannotEvaluate = cannotEvaluate;
        this.path = new ArrayList();
    }

    public /* synthetic */ ValueEvaluator(Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function2 = 1.INSTANCE;
        }
        this((Function2<? super Node, ? super ValueEvaluator, ? extends Object>)function2);
    }

    @NotNull
    public final Function2<Node, ValueEvaluator, Object> getCannotEvaluate() {
        return this.cannotEvaluate;
    }

    @NotNull
    protected Logger getLog() {
        Logger logger = LoggerFactory.getLogger(ValueEvaluator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ValueEvaluator::class.java)");
        return logger;
    }

    @NotNull
    public final List<Node> getPath() {
        return this.path;
    }

    @Nullable
    public Object evaluate(@Nullable Object node) {
        if (!(node instanceof Node)) {
            return node;
        }
        return this.evaluateInternal(node instanceof Node ? (Node)node : null, 0);
    }

    @Nullable
    protected Object evaluateInternal(@Nullable Node node, int depth) {
        Node node2 = node;
        if (node2 != null) {
            Node it = node2;
            boolean bl = false;
            ((Collection)this.path).add(it);
        }
        Node node3 = node;
        if (node3 instanceof ArrayCreationExpression) {
            return this.evaluateInternal((Node)((ArrayCreationExpression)node).getInitializer(), depth + 1);
        }
        if (node3 instanceof VariableDeclaration) {
            return this.evaluateInternal((Node)((VariableDeclaration)node).getInitializer(), depth + 1);
        }
        if (node3 instanceof Literal) {
            return ((Literal)node).getValue();
        }
        if (node3 instanceof DeclaredReferenceExpression) {
            return this.handleDeclaredReferenceExpression((DeclaredReferenceExpression)node, depth);
        }
        if (node3 instanceof UnaryOperator) {
            return this.handleUnaryOp((UnaryOperator)node, depth);
        }
        if (node3 instanceof BinaryOperator) {
            return this.handleBinaryOperator((BinaryOperator)node, depth);
        }
        if (node3 instanceof CastExpression) {
            return this.evaluateInternal((Node)((CastExpression)node).getExpression(), depth + 1);
        }
        if (node3 instanceof ArraySubscriptionExpression) {
            return this.handleArraySubscriptionExpression((ArraySubscriptionExpression)node, depth);
        }
        if (node3 instanceof ConditionalExpression) {
            return this.handleConditionalExpression((ConditionalExpression)node, depth);
        }
        return this.cannotEvaluate.invoke((Object)node, (Object)this);
    }

    @Nullable
    protected Object handleBinaryOperator(@NotNull BinaryOperator expr, int depth) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Object rhsValue = this.evaluateInternal((Node)expr.getRhs(), depth + 1);
        Object lhsValue = this.evaluateInternal((Node)expr.getLhs(), depth + 1);
        return this.computeBinaryOpEffect(lhsValue, rhsValue, expr);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    protected final Object computeBinaryOpEffect(@Nullable Object lhsValue, @Nullable Object rhsValue, @NotNull BinaryOperator expr) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        String string = expr.getOperatorCode();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1952: {
                    if (!string.equals("==")) break;
                    n = 1;
                    break;
                }
                case 1921: {
                    if (!string.equals("<=")) break;
                    n = 2;
                    break;
                }
                case 42: {
                    if (!string.equals("*")) break;
                    n = 3;
                    break;
                }
                case 43: {
                    if (!string.equals("+")) break;
                    n = 4;
                    break;
                }
                case 45: {
                    if (!string.equals("-")) break;
                    n = 5;
                    break;
                }
                case 1518: {
                    if (!string.equals("/=")) break;
                    n = 6;
                    break;
                }
                case 47: {
                    if (!string.equals("/")) break;
                    n = 6;
                    break;
                }
                case 1456: {
                    if (!string.equals("-=")) break;
                    n = 5;
                    break;
                }
                case 1394: {
                    if (!string.equals("+=")) break;
                    n = 4;
                    break;
                }
                case 1363: {
                    if (!string.equals("*=")) break;
                    n = 3;
                    break;
                }
                case 60: {
                    if (!string.equals("<")) break;
                    n = 7;
                    break;
                }
                case 62: {
                    if (!string.equals(">")) break;
                    n = 8;
                    break;
                }
                case 1983: {
                    if (!string.equals(">=")) break;
                    n = 9;
                    break;
                }
            }
            switch (n) {
                case 4: {
                    object = this.handlePlus(lhsValue, rhsValue, expr);
                    return object;
                }
                case 5: {
                    object = this.handleMinus(lhsValue, rhsValue, expr);
                    return object;
                }
                case 6: {
                    object = this.handleDiv(lhsValue, rhsValue, expr);
                    return object;
                }
                case 3: {
                    object = this.handleTimes(lhsValue, rhsValue, expr);
                    return object;
                }
                case 8: {
                    object = this.handleGreater(lhsValue, rhsValue, expr);
                    return object;
                }
                case 9: {
                    object = this.handleGEq(lhsValue, rhsValue, expr);
                    return object;
                }
                case 7: {
                    object = this.handleLess(lhsValue, rhsValue, expr);
                    return object;
                }
                case 2: {
                    object = this.handleLEq(lhsValue, rhsValue, expr);
                    return object;
                }
                case 1: {
                    object = this.handleEq(lhsValue, rhsValue, expr);
                    return object;
                }
            }
        }
        object = this.cannotEvaluate.invoke((Object)expr, (Object)this);
        return object;
    }

    private final Object handlePlus(Object lhsValue, Object rhsValue, BinaryOperator expr) {
        return lhsValue instanceof String ? "" + lhsValue + rhsValue : (lhsValue instanceof Integer && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() + ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Integer && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() + ((Number)rhsValue).longValue()) : (lhsValue instanceof Long && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() + ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Long && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() + ((Number)rhsValue).longValue()) : (lhsValue instanceof Short && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() + ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Short && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() + ((Number)rhsValue).longValue()) : (lhsValue instanceof Byte && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() + ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Byte && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() + ((Number)rhsValue).longValue()) : (lhsValue instanceof Double && rhsValue instanceof Number ? Double.valueOf(((Number)lhsValue).doubleValue() + ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Float && rhsValue instanceof Number ? Double.valueOf(((Number)lhsValue).doubleValue() + ((Number)rhsValue).doubleValue()) : this.cannotEvaluate.invoke((Object)expr, (Object)this)))))))))));
    }

    private final Object handleMinus(Object lhsValue, Object rhsValue, BinaryOperator expr) {
        return lhsValue instanceof Integer && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() - ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Integer && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() - ((Number)rhsValue).longValue()) : (lhsValue instanceof Long && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() - ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Long && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() - ((Number)rhsValue).longValue()) : (lhsValue instanceof Short && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() - ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Short && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() - ((Number)rhsValue).longValue()) : (lhsValue instanceof Byte && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() - ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Byte && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() - ((Number)rhsValue).longValue()) : (lhsValue instanceof Double && rhsValue instanceof Number ? Double.valueOf(((Number)lhsValue).doubleValue() - ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Float && rhsValue instanceof Number ? Double.valueOf(((Number)lhsValue).doubleValue() - ((Number)rhsValue).doubleValue()) : this.cannotEvaluate.invoke((Object)expr, (Object)this))))))))));
    }

    private final Object handleDiv(Object lhsValue, Object rhsValue, BinaryOperator expr) {
        return Intrinsics.areEqual((Object)rhsValue, (Object)0) ? this.cannotEvaluate.invoke((Object)expr, (Object)this) : (lhsValue instanceof Integer && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() / ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Integer && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() / ((Number)rhsValue).longValue()) : (lhsValue instanceof Long && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() / ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Long && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() / ((Number)rhsValue).longValue()) : (lhsValue instanceof Short && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() / ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Short && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() / ((Number)rhsValue).longValue()) : (lhsValue instanceof Byte && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() / ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Byte && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() / ((Number)rhsValue).longValue()) : (lhsValue instanceof Double && rhsValue instanceof Number ? Double.valueOf(((Number)lhsValue).doubleValue() / ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Float && rhsValue instanceof Number ? Double.valueOf(((Number)lhsValue).doubleValue() / ((Number)rhsValue).doubleValue()) : this.cannotEvaluate.invoke((Object)expr, (Object)this)))))))))));
    }

    private final Object handleTimes(Object lhsValue, Object rhsValue, BinaryOperator expr) {
        return lhsValue instanceof Integer && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() * ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Integer && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() * ((Number)rhsValue).longValue()) : (lhsValue instanceof Long && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() * ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Long && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() * ((Number)rhsValue).longValue()) : (lhsValue instanceof Short && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() * ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Short && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() * ((Number)rhsValue).longValue()) : (lhsValue instanceof Byte && (rhsValue instanceof Double || rhsValue instanceof Float) ? Double.valueOf(((Number)lhsValue).doubleValue() * ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Byte && rhsValue instanceof Number ? Long.valueOf(((Number)lhsValue).longValue() * ((Number)rhsValue).longValue()) : (lhsValue instanceof Double && rhsValue instanceof Number ? Double.valueOf(((Number)lhsValue).doubleValue() * ((Number)rhsValue).doubleValue()) : (lhsValue instanceof Float && rhsValue instanceof Number ? Double.valueOf(((Number)lhsValue).doubleValue() * ((Number)rhsValue).doubleValue()) : this.cannotEvaluate.invoke((Object)expr, (Object)this))))))))));
    }

    private final Object handleGreater(Object lhsValue, Object rhsValue, BinaryOperator expr) {
        return lhsValue instanceof Number && rhsValue instanceof Number ? Boolean.valueOf(ValueEvaluatorKt.compareTo((Number)lhsValue, (Number)rhsValue) > 0) : this.cannotEvaluate.invoke((Object)expr, (Object)this);
    }

    private final Object handleGEq(Object lhsValue, Object rhsValue, BinaryOperator expr) {
        return lhsValue instanceof Number && rhsValue instanceof Number ? Boolean.valueOf(ValueEvaluatorKt.compareTo((Number)lhsValue, (Number)rhsValue) >= 0) : this.cannotEvaluate.invoke((Object)expr, (Object)this);
    }

    private final Object handleLess(Object lhsValue, Object rhsValue, BinaryOperator expr) {
        return lhsValue instanceof Number && rhsValue instanceof Number ? Boolean.valueOf(ValueEvaluatorKt.compareTo((Number)lhsValue, (Number)rhsValue) < 0) : this.cannotEvaluate.invoke((Object)expr, (Object)this);
    }

    private final Object handleLEq(Object lhsValue, Object rhsValue, BinaryOperator expr) {
        return lhsValue instanceof Number && rhsValue instanceof Number ? Boolean.valueOf(ValueEvaluatorKt.compareTo((Number)lhsValue, (Number)rhsValue) <= 0) : this.cannotEvaluate.invoke((Object)expr, (Object)this);
    }

    private final Object handleEq(Object lhsValue, Object rhsValue, BinaryOperator expr) {
        return lhsValue instanceof Number && rhsValue instanceof Number ? Boolean.valueOf(ValueEvaluatorKt.compareTo((Number)lhsValue, (Number)rhsValue) == 0) : this.cannotEvaluate.invoke((Object)expr, (Object)this);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected Object handleUnaryOp(@NotNull UnaryOperator expr, int depth) {
        block14: {
            block10: {
                block12: {
                    block13: {
                        block11: {
                            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                            var3_3 = expr.getOperatorCode();
                            if (var3_3 == null) break block10;
                            switch (var3_3.hashCode()) {
                                case 1440: {
                                    if (var3_3.equals("--")) break;
                                    ** break;
                                }
                                case 1376: {
                                    if (!var3_3.equals("++")) {
                                        ** break;
                                    }
                                    break block11;
                                }
                                case 38: {
                                    if (!var3_3.equals("&")) {
                                        ** break;
                                    }
                                    break block12;
                                }
                                case 42: {
                                    if (!var3_3.equals("*")) {
                                        ** break;
                                    }
                                    break block13;
                                }
                                case 45: {
                                    if (!var3_3.equals("-")) ** break;
                                    input = this.evaluateInternal((Node)expr.getInput(), depth + 1);
                                    v0 = input instanceof Number ? ValueEvaluatorKt.negate((Number)input) : this.cannotEvaluate.invoke((Object)expr, (Object)this);
                                    break block14;
                                }
                            }
                            input = this.evaluateInternal((Node)expr.getInput(), depth + 1);
                            v0 = input instanceof Number ? ValueEvaluatorKt.decrement((Number)input) : this.cannotEvaluate.invoke((Object)expr, (Object)this);
                            break block14;
                        }
                        input = this.evaluateInternal((Node)expr.getInput(), depth + 1);
                        v0 = input instanceof Number ? ValueEvaluatorKt.increment((Number)input) : this.cannotEvaluate.invoke((Object)expr, (Object)this);
                        break block14;
                    }
                    v0 = this.evaluateInternal((Node)expr.getInput(), depth + 1);
                    break block14;
                }
                v0 = this.evaluateInternal((Node)expr.getInput(), depth + 1);
                break block14;
            }
            v0 = this.cannotEvaluate.invoke((Object)expr, (Object)this);
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final Object handleArraySubscriptionExpression(@NotNull ArraySubscriptionExpression expr, int depth) {
        InitializerListExpression ile;
        VariableDeclaration array;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Expression expression = expr.getArrayExpression();
        DeclaredReferenceExpression declaredReferenceExpression = expression instanceof DeclaredReferenceExpression ? (DeclaredReferenceExpression)expression : null;
        Declaration declaration = declaredReferenceExpression != null ? declaredReferenceExpression.getRefersTo() : null;
        VariableDeclaration variableDeclaration = array = declaration instanceof VariableDeclaration ? (VariableDeclaration)declaration : null;
        Expression expression2 = variableDeclaration != null ? variableDeclaration.getInitializer() : null;
        InitializerListExpression initializerListExpression = ile = expression2 instanceof InitializerListExpression ? (InitializerListExpression)expression2 : null;
        if (ile != null) {
            Object v7;
            ValueEvaluator valueEvaluator;
            block4: {
                void $this$firstOrNull$iv;
                InitializerListExpression it = ile;
                boolean bl = false;
                Iterable iterable = CollectionsKt.filterIsInstance((Iterable)it.getInitializers(), KeyValueExpression.class);
                valueEvaluator = this;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KeyValueExpression kve = (KeyValueExpression)element$iv;
                    boolean bl2 = false;
                    Expression expression3 = kve.getKey();
                    Literal literal = expression3 instanceof Literal ? (Literal)expression3 : null;
                    Object object = literal != null ? literal.getValue() : null;
                    expression3 = expr.getSubscriptExpression();
                    Literal literal2 = expression3 instanceof Literal ? (Literal)expression3 : null;
                    Object object2 = literal2 != null ? literal2.getValue() : null;
                    if (!Intrinsics.areEqual((Object)object, (Object)object2)) continue;
                    v7 = element$iv;
                    break block4;
                }
                v7 = null;
            }
            KeyValueExpression keyValueExpression = v7;
            return valueEvaluator.evaluateInternal((Node)(keyValueExpression != null ? keyValueExpression.getValue() : null), depth + 1);
        }
        VariableDeclaration variableDeclaration2 = array;
        if ((variableDeclaration2 != null ? variableDeclaration2.getInitializer() : null) instanceof Literal) {
            Expression expression4 = array.getInitializer();
            Intrinsics.checkNotNull((Object)expression4, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal<*>");
            return ((Literal)expression4).getValue();
        }
        if (expr.getArrayExpression() instanceof ArraySubscriptionExpression) {
            return this.evaluateInternal((Node)expr.getArrayExpression(), depth + 1);
        }
        return this.cannotEvaluate.invoke((Object)expr, (Object)this);
    }

    @Nullable
    protected Object handleConditionalExpression(@NotNull ConditionalExpression expr, int depth) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        if (expr.getCondition() instanceof BinaryOperator) {
            Expression expression = expr.getCondition();
            BinaryOperator binaryOperator = expression instanceof BinaryOperator ? (BinaryOperator)expression : null;
            Object lhs = this.evaluateInternal((Node)(binaryOperator != null ? binaryOperator.getLhs() : null), depth);
            Expression expression2 = expr.getCondition();
            BinaryOperator binaryOperator2 = expression2 instanceof BinaryOperator ? (BinaryOperator)expression2 : null;
            Object rhs = this.evaluateInternal((Node)(binaryOperator2 != null ? binaryOperator2.getRhs() : null), depth);
            return Intrinsics.areEqual((Object)lhs, (Object)rhs) ? this.evaluateInternal((Node)expr.getThenExpr(), depth + 1) : this.evaluateInternal((Node)expr.getElseExpr(), depth + 1);
        }
        return this.cannotEvaluate.invoke((Object)expr, (Object)this);
    }

    @Nullable
    protected Object handleDeclaredReferenceExpression(@NotNull DeclaredReferenceExpression expr, int depth) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        List<Node> prevDFG = this.filterSelfReferences(expr, CollectionsKt.toList((Iterable)expr.getPrevDFG()));
        if (prevDFG.size() == 1) {
            object = this.evaluateInternal((Node)CollectionsKt.first(prevDFG), depth + 1);
        } else if (prevDFG.size() > 1) {
            this.getLog().warn("We cannot evaluate {}: It has more than 1 previous DFG edges, meaning that the value is probably affected by a branch.", (Object)expr);
            object = this.cannotEvaluate.invoke((Object)expr, (Object)this);
        } else {
            this.getLog().warn("We cannot evaluate {}: It has no previous DFG edges.", (Object)expr);
            object = this.cannotEvaluate.invoke((Object)expr, (Object)this);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<Node> filterSelfReferences(@NotNull DeclaredReferenceExpression ref, @NotNull List<? extends Node> inDFG) {
        boolean isCase2;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter(inDFG, (String)"inDFG");
        List list = inDFG;
        boolean bl = isCase2 = this.path.size() > 2 && this.path.subList(0, this.path.size() - 2).contains(ref);
        if (ref.getAccess() == AccessValues.READWRITE && isCase2) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Node it = (Node)element$iv$iv;
                boolean bl2 = false;
                boolean bl3 = !(it instanceof BinaryOperator && Intrinsics.areEqual((Object)((BinaryOperator)it).getLhs(), (Object)ref) || it instanceof UnaryOperator && Intrinsics.areEqual((Object)((UnaryOperator)it).getInput(), (Object)ref));
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (ref.getAccess() == AccessValues.READWRITE && !isCase2) {
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Node it = (Node)element$iv$iv;
                boolean bl4 = false;
                boolean bl5 = it instanceof BinaryOperator && Intrinsics.areEqual((Object)((BinaryOperator)it).getLhs(), (Object)ref) || it instanceof UnaryOperator && Intrinsics.areEqual((Object)((UnaryOperator)it).getInput(), (Object)ref);
                if (!bl5) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public ValueEvaluator() {
        this(null, 1, null);
    }
}

