/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis;

import de.fraunhofer.aisec.cpg.analysis.NumberSet;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/ConcreteNumberSet;", "Lde/fraunhofer/aisec/cpg/analysis/NumberSet;", "values", "", "", "(Ljava/util/Set;)V", "getValues", "()Ljava/util/Set;", "setValues", "addValue", "", "value", "clear", "max", "maybe", "", "min", "cpg-analysis"})
public final class ConcreteNumberSet
extends NumberSet {
    @NotNull
    private Set<Long> values;

    public ConcreteNumberSet(@NotNull Set<Long> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.values = values;
    }

    public /* synthetic */ ConcreteNumberSet(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new LinkedHashSet();
        }
        this(set);
    }

    @NotNull
    public final Set<Long> getValues() {
        return this.values;
    }

    public final void setValues(@NotNull Set<Long> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.values = set;
    }

    @Override
    public void addValue(long value) {
        this.values.add(value);
    }

    @Override
    public long min() {
        Long l = (Long)CollectionsKt.minOrNull((Iterable)this.values);
        return l != null ? l : Long.MAX_VALUE;
    }

    @Override
    public long max() {
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)this.values);
        return l != null ? l : Long.MIN_VALUE;
    }

    @Override
    public boolean maybe(long value) {
        return this.values.contains(value);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    public ConcreteNumberSet() {
        this(null, 1, null);
    }
}

