/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis.fsm;

import de.fraunhofer.aisec.cpg.analysis.fsm.BaseOpEdge;
import de.fraunhofer.aisec.cpg.analysis.fsm.FSMBuilderException;
import de.fraunhofer.aisec.cpg.analysis.fsm.State;
import de.fraunhofer.aisec.cpg.graph.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001fJ\u001a\u0010!\u001a\u00020\u00042\b\b\u0002\u0010\"\u001a\u00020\u001b2\b\b\u0002\u0010#\u001a\u00020\u001bJ\b\u0010$\u001a\u00020\u0000H\u0016J\u0013\u0010%\u001a\u00020\u001b2\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\u0006\u0010(\u001a\u00020\u001bJ\u0016\u0010)\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\fJ\u0006\u0010+\u001a\u00020\u001fR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR2\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/fsm/DFA;", "", "()V", "currentState", "Lde/fraunhofer/aisec/cpg/analysis/fsm/State;", "getCurrentState", "()Lde/fraunhofer/aisec/cpg/analysis/fsm/State;", "setCurrentState", "(Lde/fraunhofer/aisec/cpg/analysis/fsm/State;)V", "executionTrace", "", "Lkotlin/Triple;", "Lde/fraunhofer/aisec/cpg/graph/Node;", "Lde/fraunhofer/aisec/cpg/analysis/fsm/BaseOpEdge;", "getExecutionTrace", "()Ljava/util/List;", "setExecutionTrace", "(Ljava/util/List;)V", "stateCounter", "", "states", "", "getStates", "()Ljava/util/Set;", "setStates", "(Ljava/util/Set;)V", "addEdge", "", "from", "to", "op", "", "base", "addState", "isStart", "isAcceptingState", "clone", "equals", "other", "", "isAccepted", "makeTransitionWithOp", "node", "toDotString", "Companion", "cpg-analysis"})
public final class DFA
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Set<State> states = new LinkedHashSet();
    private int stateCounter = 1;
    @Nullable
    private State currentState;
    @NotNull
    private List<Triple<State, Node, BaseOpEdge>> executionTrace = new ArrayList();
    @NotNull
    private static final String EPSILON = "\u03b5";

    @NotNull
    public final Set<State> getStates() {
        return this.states;
    }

    public final void setStates(@NotNull Set<State> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.states = set;
    }

    @Nullable
    public final State getCurrentState() {
        return this.currentState;
    }

    public final void setCurrentState(@Nullable State state) {
        this.currentState = state;
    }

    @NotNull
    public final List<Triple<State, Node, BaseOpEdge>> getExecutionTrace() {
        return this.executionTrace;
    }

    public final void setExecutionTrace(@NotNull List<Triple<State, Node, BaseOpEdge>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.executionTrace = list;
    }

    public final boolean addEdge(@NotNull State from, @NotNull State to, @NotNull String op, @Nullable String base) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            this.states.add(from);
            this.states.add(to);
            Iterable $this$any$iv = from.getOutgoingEdges();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BaseOpEdge e = (BaseOpEdge)element$iv;
                    boolean bl2 = false;
                    if (!(e.matches(base, op) && !Intrinsics.areEqual((Object)e.getNextState(), (Object)to))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new FSMBuilderException("State already has an outgoing edge with the same label but a different target!");
        }
        from.addOutgoingEdge(new BaseOpEdge(op, base, to));
        return true;
    }

    @NotNull
    public final State addState(boolean isStart, boolean isAcceptingState) {
        State newState = new State("" + 'q' + this.stateCounter, isStart, isAcceptingState);
        if (isStart) {
            this.currentState = newState;
        }
        this.states.add(newState);
        int n = this.stateCounter;
        this.stateCounter = n + 1;
        return newState;
    }

    public static /* synthetic */ State addState$default(DFA dFA, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return dFA.addState(bl, bl2);
    }

    @NotNull
    public final String toDotString() {
        String str = "digraph fsm {\n\t\"\" [shape=point];\n";
        String edges = "";
        for (State s : this.states) {
            str = str + (s.isAcceptingState() ? '\t' + s.getName() + " [shape=doublecircle];\n" : '\t' + s.getName() + " [shape=circle];\n");
            if (s.isStart()) {
                edges = edges + "\t\"\" -> " + s.getName() + ";\n";
            }
            for (BaseOpEdge e : s.getOutgoingEdges()) {
                edges = edges + '\t' + s.getName() + " -> " + e.getNextState().getName() + " [label=\"" + e.toDotLabel() + "\"];\n";
            }
        }
        return str + edges + '}';
    }

    public final boolean makeTransitionWithOp(@NotNull String op, @NotNull Node node) {
        boolean retVal;
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.currentState == null) {
            throw new Exception("Cannot make transition because the FSM does not have a starting state!");
        }
        State state = this.currentState;
        Pair<State, BaseOpEdge> newState = state != null ? state.nextNodeWithLabelOp(op) : null;
        boolean bl = retVal = newState != null;
        while (newState != null) {
            State state2 = this.currentState;
            Intrinsics.checkNotNull((Object)state2);
            this.executionTrace.add((Triple<State, Node, BaseOpEdge>)new Triple((Object)state2, (Object)node, newState.getSecond()));
            State state3 = this.currentState = (State)newState.getFirst();
            newState = state3 != null ? state3.nextNodeWithLabelOp(EPSILON) : null;
        }
        return retVal;
    }

    @NotNull
    public DFA clone() {
        DFA newDFA = new DFA();
        State state = this.currentState;
        newDFA.currentState = state != null ? state.clone() : null;
        newDFA.states = this.states;
        newDFA.executionTrace = new ArrayList();
        newDFA.executionTrace.addAll((Collection<Triple<State, Node, BaseOpEdge>>)this.executionTrace);
        return newDFA;
    }

    public final boolean isAccepted() {
        State state = this.currentState;
        return state != null ? state.isAcceptingState() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        State s;
        Object element$iv;
        State otherState;
        if (other == null) return false;
        if (!(other instanceof DFA)) return false;
        State state = ((DFA)other).currentState;
        Intrinsics.checkNotNull((Object)state);
        if (!state.equals(this.currentState)) return false;
        if (((DFA)other).stateCounter != this.stateCounter) return false;
        if (!Intrinsics.areEqual(((DFA)other).states, this.states)) return false;
        boolean bl = true;
        boolean res = bl;
        if (!res) return res;
        Iterator<State> iterator = this.states.iterator();
        do {
            State otherS;
            if (!iterator.hasNext()) return res;
            s = iterator.next();
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.analysis.fsm.DFA");
            Iterable $this$first$iv = ((DFA)other).states;
            boolean $i$f$first = false;
            Iterator iterator2 = $this$first$iv.iterator();
            do {
                if (!iterator2.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
                element$iv = iterator2.next();
                otherS = (State)element$iv;
                boolean bl2 = false;
            } while (!Intrinsics.areEqual((Object)s.getName(), (Object)otherS.getName()));
        } while (Intrinsics.areEqual((otherState = (State)element$iv).getOutgoingEdges(), s.getOutgoingEdges()));
        return false;
    }

    @NotNull
    public static final String getEPSILON() {
        return Companion.getEPSILON();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/fsm/DFA$Companion;", "", "()V", "EPSILON", "", "getEPSILON$annotations", "getEPSILON", "()Ljava/lang/String;", "cpg-analysis"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getEPSILON() {
            return EPSILON;
        }

        @JvmStatic
        public static /* synthetic */ void getEPSILON$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

