/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.analysis.fsm;

import de.fraunhofer.aisec.cpg.analysis.fsm.State;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0015"}, d2={"Lde/fraunhofer/aisec/cpg/analysis/fsm/BaseOpEdge;", "", "op", "", "base", "nextState", "Lde/fraunhofer/aisec/cpg/analysis/fsm/State;", "(Ljava/lang/String;Ljava/lang/String;Lde/fraunhofer/aisec/cpg/analysis/fsm/State;)V", "getBase", "()Ljava/lang/String;", "getNextState", "()Lde/fraunhofer/aisec/cpg/analysis/fsm/State;", "getOp", "equals", "", "other", "hashCode", "", "matches", "toDotLabel", "toString", "cpg-analysis"})
public final class BaseOpEdge {
    @NotNull
    private final String op;
    @Nullable
    private final String base;
    @NotNull
    private final State nextState;

    public BaseOpEdge(@NotNull String op, @Nullable String base, @NotNull State nextState) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)nextState, (String)"nextState");
        this.op = op;
        this.base = base;
        this.nextState = nextState;
    }

    @NotNull
    public final String getOp() {
        return this.op;
    }

    @Nullable
    public final String getBase() {
        return this.base;
    }

    @NotNull
    public final State getNextState() {
        return this.nextState;
    }

    public final boolean matches(@Nullable String base, @NotNull String op) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return Intrinsics.areEqual((Object)this.base, (Object)base) && Intrinsics.areEqual((Object)this.op, (Object)op);
    }

    @NotNull
    public String toString() {
        return this.base != null ? "-- " + this.base + '.' + this.op + " --> " + this.nextState : "-- " + this.op + " --> " + this.nextState;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof BaseOpEdge)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.op, (Object)((BaseOpEdge)other).op) && Intrinsics.areEqual((Object)this.base, (Object)((BaseOpEdge)other).base) && Intrinsics.areEqual((Object)this.nextState, (Object)((BaseOpEdge)other).nextState);
    }

    @NotNull
    public final String toDotLabel() {
        return this.base != null ? this.base + '.' + this.op : this.op;
    }

    public int hashCode() {
        int n;
        int result = this.op.hashCode();
        String string = this.base;
        result = 31 * result + (string == null ? 0 : (n = string.hashCode()));
        result = 31 * result + this.nextState.hashCode();
        return result;
    }
}

