/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.impl.uuid.provider.s3;

import de.frachtwerk.essencium.storage.generic.model.StorageInfoVisitor;
import de.frachtwerk.essencium.storage.generic.provider.s3.AbstractS3StorageInfo;
import de.frachtwerk.essencium.storage.impl.uuid.model.UUIDFile;
import de.frachtwerk.essencium.storage.impl.uuid.model.UUIDStorageInfo;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.validation.constraints.NotNull;
import java.util.UUID;
import lombok.Generated;

@Entity(name="S3_STORAGE_INFO")
public class S3UUIDStorageInfo
extends UUIDStorageInfo
implements AbstractS3StorageInfo<UUIDFile, UUID, UUIDStorageInfo> {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private UUID id;
    @NotNull
    private String s3ObjectKey;

    public S3UUIDStorageInfo(UUIDFile file, @NotNull String s3ObjectKey) {
        super(file);
        this.s3ObjectKey = s3ObjectKey;
    }

    @Override
    public <T> T accept(StorageInfoVisitor<T, UUIDFile, UUID, UUIDStorageInfo> visitor) {
        return visitor.visit(this);
    }

    public String getTitle() {
        return "S3UUIDStorageInfo " + this.id;
    }

    @Generated
    protected S3UUIDStorageInfo(S3UUIDStorageInfoBuilder<?, ?> b) {
        super((UUIDStorageInfo.UUIDStorageInfoBuilder<?, ?>)b);
        this.id = b.id;
        this.s3ObjectKey = b.s3ObjectKey;
    }

    @Generated
    public static S3UUIDStorageInfoBuilder<?, ?> builder() {
        return new S3UUIDStorageInfoBuilderImpl();
    }

    @Generated
    public S3UUIDStorageInfoBuilder<?, ?> toBuilder() {
        return new S3UUIDStorageInfoBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3UUIDStorageInfo)) {
            return false;
        }
        S3UUIDStorageInfo other = (S3UUIDStorageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$s3ObjectKey = this.getS3ObjectKey();
        String other$s3ObjectKey = other.getS3ObjectKey();
        return !(this$s3ObjectKey == null ? other$s3ObjectKey != null : !this$s3ObjectKey.equals(other$s3ObjectKey));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof S3UUIDStorageInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $s3ObjectKey = this.getS3ObjectKey();
        result = result * 59 + ($s3ObjectKey == null ? 43 : $s3ObjectKey.hashCode());
        return result;
    }

    @Generated
    public S3UUIDStorageInfo(UUID id, String s3ObjectKey) {
        this.id = id;
        this.s3ObjectKey = s3ObjectKey;
    }

    @Generated
    public S3UUIDStorageInfo() {
    }

    @Override
    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getS3ObjectKey() {
        return this.s3ObjectKey;
    }

    @Override
    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setS3ObjectKey(String s3ObjectKey) {
        this.s3ObjectKey = s3ObjectKey;
    }

    @Override
    @Generated
    public String toString() {
        return "S3UUIDStorageInfo(id=" + this.getId() + ", s3ObjectKey=" + this.getS3ObjectKey() + ")";
    }

    @Generated
    public static abstract class S3UUIDStorageInfoBuilder<C extends S3UUIDStorageInfo, B extends S3UUIDStorageInfoBuilder<C, B>>
    extends UUIDStorageInfo.UUIDStorageInfoBuilder<C, B> {
        @Generated
        private UUID id;
        @Generated
        private String s3ObjectKey;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            S3UUIDStorageInfoBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)((Object)this.self());
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(S3UUIDStorageInfo instance, S3UUIDStorageInfoBuilder<?, ?> b) {
            b.id(instance.id);
            b.s3ObjectKey(instance.s3ObjectKey);
        }

        @Override
        @Generated
        public B id(UUID id) {
            this.id = id;
            return (B)((Object)this.self());
        }

        @Generated
        public B s3ObjectKey(String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "S3UUIDStorageInfo.S3UUIDStorageInfoBuilder(super=" + super.toString() + ", id=" + this.id + ", s3ObjectKey=" + this.s3ObjectKey + ")";
        }
    }

    @Generated
    private static final class S3UUIDStorageInfoBuilderImpl
    extends S3UUIDStorageInfoBuilder<S3UUIDStorageInfo, S3UUIDStorageInfoBuilderImpl> {
        @Generated
        private S3UUIDStorageInfoBuilderImpl() {
        }

        @Override
        @Generated
        protected S3UUIDStorageInfoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public S3UUIDStorageInfo build() {
            return new S3UUIDStorageInfo(this);
        }
    }
}

