/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.impl.uuid.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.frachtwerk.essencium.storage.generic.model.AbstractFile;
import de.frachtwerk.essencium.storage.generic.model.AbstractStorageInfo;
import de.frachtwerk.essencium.storage.generic.model.StorageInfoVisitor;
import de.frachtwerk.essencium.storage.impl.uuid.model.UUIDStorageInfo;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.core.io.Resource;

@Entity(name="FILE")
public class UUIDFile
extends AbstractFile<UUIDFile, UUID, UUIDStorageInfo> {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private UUID id;
    @NotNull
    @OrderColumn
    @OneToMany(cascade={CascadeType.ALL})
    List<UUIDStorageInfo> storageInfos;

    public UUIDFile(@NotNull List<UUIDStorageInfo> infos, String name, int length, String mimeType) {
        super(name, length, mimeType);
        this.storageInfos = infos;
    }

    @Override
    public boolean isAvailable() {
        return this.storageInfos.stream().anyMatch(AbstractStorageInfo::isAvailable);
    }

    @JsonIgnore
    public Resource getContent() {
        return this.storageInfos.stream().map(AbstractStorageInfo::getContent).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public <T> Set<T> accept(StorageInfoVisitor<T, UUIDFile, UUID, UUIDStorageInfo> visitor) {
        return this.storageInfos.stream().map(i -> i.accept(visitor)).collect(Collectors.toSet());
    }

    public String getTitle() {
        return "UUIDFile " + this.id;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public List<UUIDStorageInfo> getStorageInfos() {
        return this.storageInfos;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setStorageInfos(List<UUIDStorageInfo> storageInfos) {
        this.storageInfos = storageInfos;
    }

    @Override
    @Generated
    public String toString() {
        return "UUIDFile(id=" + this.getId() + ", storageInfos=" + this.getStorageInfos() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UUIDFile)) {
            return false;
        }
        UUIDFile other = (UUIDFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<UUIDStorageInfo> this$storageInfos = this.getStorageInfos();
        List<UUIDStorageInfo> other$storageInfos = other.getStorageInfos();
        return !(this$storageInfos == null ? other$storageInfos != null : !((Object)this$storageInfos).equals(other$storageInfos));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UUIDFile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<UUIDStorageInfo> $storageInfos = this.getStorageInfos();
        result = result * 59 + ($storageInfos == null ? 43 : ((Object)$storageInfos).hashCode());
        return result;
    }

    @Generated
    public UUIDFile() {
    }

    @Generated
    public UUIDFile(UUID id, List<UUIDStorageInfo> storageInfos) {
        this.id = id;
        this.storageInfos = storageInfos;
    }
}

