/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.impl.sequence.provider.s3;

import de.frachtwerk.essencium.storage.generic.model.StorageInfoVisitor;
import de.frachtwerk.essencium.storage.generic.provider.s3.AbstractS3StorageInfo;
import de.frachtwerk.essencium.storage.impl.sequence.model.SequenceFile;
import de.frachtwerk.essencium.storage.impl.sequence.model.SequenceStorageInfo;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

@Entity(name="S3_STORAGE_INFO")
public class S3SequenceStorageInfo
extends SequenceStorageInfo
implements AbstractS3StorageInfo<SequenceFile, Long, SequenceStorageInfo> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="hibernate_sequence")
    @SequenceGenerator(name="hibernate_sequence", sequenceName="hibernate_sequence", allocationSize=1)
    private Long id;
    @NotNull
    private String s3ObjectKey;

    public S3SequenceStorageInfo(SequenceFile file, @NotNull String s3ObjectKey) {
        super(file);
        this.s3ObjectKey = s3ObjectKey;
    }

    @Override
    public <T> T accept(StorageInfoVisitor<T, SequenceFile, Long, SequenceStorageInfo> visitor) {
        return visitor.visit(this);
    }

    public String getTitle() {
        return "S3SequenceStorageInfo " + this.id;
    }

    @Generated
    protected S3SequenceStorageInfo(S3SequenceStorageInfoBuilder<?, ?> b) {
        super((SequenceStorageInfo.SequenceStorageInfoBuilder<?, ?>)b);
        this.id = b.id;
        this.s3ObjectKey = b.s3ObjectKey;
    }

    @Generated
    public static S3SequenceStorageInfoBuilder<?, ?> builder() {
        return new S3SequenceStorageInfoBuilderImpl();
    }

    @Generated
    public S3SequenceStorageInfoBuilder<?, ?> toBuilder() {
        return new S3SequenceStorageInfoBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3SequenceStorageInfo)) {
            return false;
        }
        S3SequenceStorageInfo other = (S3SequenceStorageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$s3ObjectKey = this.getS3ObjectKey();
        String other$s3ObjectKey = other.getS3ObjectKey();
        return !(this$s3ObjectKey == null ? other$s3ObjectKey != null : !this$s3ObjectKey.equals(other$s3ObjectKey));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof S3SequenceStorageInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $s3ObjectKey = this.getS3ObjectKey();
        result = result * 59 + ($s3ObjectKey == null ? 43 : $s3ObjectKey.hashCode());
        return result;
    }

    @Generated
    public S3SequenceStorageInfo(Long id, String s3ObjectKey) {
        this.id = id;
        this.s3ObjectKey = s3ObjectKey;
    }

    @Generated
    public S3SequenceStorageInfo() {
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getS3ObjectKey() {
        return this.s3ObjectKey;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setS3ObjectKey(String s3ObjectKey) {
        this.s3ObjectKey = s3ObjectKey;
    }

    @Override
    @Generated
    public String toString() {
        return "S3SequenceStorageInfo(id=" + this.getId() + ", s3ObjectKey=" + this.getS3ObjectKey() + ")";
    }

    @Generated
    public static abstract class S3SequenceStorageInfoBuilder<C extends S3SequenceStorageInfo, B extends S3SequenceStorageInfoBuilder<C, B>>
    extends SequenceStorageInfo.SequenceStorageInfoBuilder<C, B> {
        @Generated
        private Long id;
        @Generated
        private String s3ObjectKey;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            S3SequenceStorageInfoBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)((Object)this.self());
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(S3SequenceStorageInfo instance, S3SequenceStorageInfoBuilder<?, ?> b) {
            b.id(instance.id);
            b.s3ObjectKey(instance.s3ObjectKey);
        }

        @Override
        @Generated
        public B id(Long id) {
            this.id = id;
            return (B)((Object)this.self());
        }

        @Generated
        public B s3ObjectKey(String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "S3SequenceStorageInfo.S3SequenceStorageInfoBuilder(super=" + super.toString() + ", id=" + this.id + ", s3ObjectKey=" + this.s3ObjectKey + ")";
        }
    }

    @Generated
    private static final class S3SequenceStorageInfoBuilderImpl
    extends S3SequenceStorageInfoBuilder<S3SequenceStorageInfo, S3SequenceStorageInfoBuilderImpl> {
        @Generated
        private S3SequenceStorageInfoBuilderImpl() {
        }

        @Override
        @Generated
        protected S3SequenceStorageInfoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public S3SequenceStorageInfo build() {
            return new S3SequenceStorageInfo(this);
        }
    }
}

