/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.impl.sequence.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.frachtwerk.essencium.storage.generic.model.AbstractFile;
import de.frachtwerk.essencium.storage.generic.model.AbstractStorageInfo;
import de.frachtwerk.essencium.storage.generic.model.StorageInfoVisitor;
import de.frachtwerk.essencium.storage.impl.sequence.model.SequenceStorageInfo;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.core.io.Resource;

@Entity(name="FILE")
public class SequenceFile
extends AbstractFile<SequenceFile, Long, SequenceStorageInfo> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="hibernate_sequence")
    @SequenceGenerator(name="hibernate_sequence", sequenceName="hibernate_sequence", allocationSize=1)
    private Long id;
    @NotNull
    @OrderColumn
    @OneToMany(cascade={CascadeType.ALL})
    List<SequenceStorageInfo> storageInfos;

    public SequenceFile(@NotNull List<SequenceStorageInfo> infos, String name, int length, String mimeType) {
        super(name, length, mimeType);
        this.storageInfos = infos;
    }

    @Override
    public boolean isAvailable() {
        return this.storageInfos.stream().anyMatch(AbstractStorageInfo::isAvailable);
    }

    @JsonIgnore
    public Resource getContent() {
        return this.storageInfos.stream().map(AbstractStorageInfo::getContent).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public <T> Set<T> accept(StorageInfoVisitor<T, SequenceFile, Long, SequenceStorageInfo> visitor) {
        return this.storageInfos.stream().map(i -> i.accept(visitor)).collect(Collectors.toSet());
    }

    public String getTitle() {
        return this.getName();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public List<SequenceStorageInfo> getStorageInfos() {
        return this.storageInfos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setStorageInfos(List<SequenceStorageInfo> storageInfos) {
        this.storageInfos = storageInfos;
    }

    @Override
    @Generated
    public String toString() {
        return "SequenceFile(id=" + this.getId() + ", storageInfos=" + this.getStorageInfos() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceFile)) {
            return false;
        }
        SequenceFile other = (SequenceFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<SequenceStorageInfo> this$storageInfos = this.getStorageInfos();
        List<SequenceStorageInfo> other$storageInfos = other.getStorageInfos();
        return !(this$storageInfos == null ? other$storageInfos != null : !((Object)this$storageInfos).equals(other$storageInfos));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SequenceFile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<SequenceStorageInfo> $storageInfos = this.getStorageInfos();
        result = result * 59 + ($storageInfos == null ? 43 : ((Object)$storageInfos).hashCode());
        return result;
    }

    @Generated
    public SequenceFile() {
    }

    @Generated
    public SequenceFile(Long id, List<SequenceStorageInfo> storageInfos) {
        this.id = id;
        this.storageInfos = storageInfos;
    }
}

