/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.impl.identity.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.frachtwerk.essencium.storage.generic.model.AbstractFile;
import de.frachtwerk.essencium.storage.generic.model.AbstractStorageInfo;
import de.frachtwerk.essencium.storage.generic.model.StorageInfoVisitor;
import de.frachtwerk.essencium.storage.impl.identity.model.IdentityStorageInfo;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.core.io.Resource;

@Entity(name="FILE")
public class IdentityFile
extends AbstractFile<IdentityFile, Long, IdentityStorageInfo> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @OrderColumn
    @OneToMany(cascade={CascadeType.ALL})
    List<IdentityStorageInfo> storageInfos;

    public IdentityFile(@NotNull List<IdentityStorageInfo> infos, String name, int length, String mimeType) {
        super(name, length, mimeType);
        this.storageInfos = infos;
    }

    @Override
    public boolean isAvailable() {
        return this.storageInfos.stream().anyMatch(AbstractStorageInfo::isAvailable);
    }

    @JsonIgnore
    public Resource getContent() {
        return this.storageInfos.stream().map(AbstractStorageInfo::getContent).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public <T> Set<T> accept(StorageInfoVisitor<T, IdentityFile, Long, IdentityStorageInfo> visitor) {
        return this.storageInfos.stream().map(i -> i.accept(visitor)).collect(Collectors.toSet());
    }

    public String getTitle() {
        return this.getName();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public List<IdentityStorageInfo> getStorageInfos() {
        return this.storageInfos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setStorageInfos(List<IdentityStorageInfo> storageInfos) {
        this.storageInfos = storageInfos;
    }

    @Override
    @Generated
    public String toString() {
        return "IdentityFile(id=" + this.getId() + ", storageInfos=" + this.getStorageInfos() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentityFile)) {
            return false;
        }
        IdentityFile other = (IdentityFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<IdentityStorageInfo> this$storageInfos = this.getStorageInfos();
        List<IdentityStorageInfo> other$storageInfos = other.getStorageInfos();
        return !(this$storageInfos == null ? other$storageInfos != null : !((Object)this$storageInfos).equals(other$storageInfos));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IdentityFile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<IdentityStorageInfo> $storageInfos = this.getStorageInfos();
        result = result * 59 + ($storageInfos == null ? 43 : ((Object)$storageInfos).hashCode());
        return result;
    }

    @Generated
    public IdentityFile() {
    }

    @Generated
    public IdentityFile(Long id, List<IdentityStorageInfo> storageInfos) {
        this.id = id;
        this.storageInfos = storageInfos;
    }
}

