/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.generic.provider.local;

import java.nio.file.Path;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="file.storage.local")
public class LocalStorageConfiguration {
    private boolean active = false;
    private String path;
    private boolean useTempFiles = false;
    private boolean keepFileName = false;

    public Path resolvePath() {
        return Path.of(this.path.replaceFirst("^~", System.getProperty("user.home")), new String[0]);
    }

    @Generated
    public LocalStorageConfiguration() {
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public boolean isUseTempFiles() {
        return this.useTempFiles;
    }

    @Generated
    public boolean isKeepFileName() {
        return this.keepFileName;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setUseTempFiles(boolean useTempFiles) {
        this.useTempFiles = useTempFiles;
    }

    @Generated
    public void setKeepFileName(boolean keepFileName) {
        this.keepFileName = keepFileName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalStorageConfiguration)) {
            return false;
        }
        LocalStorageConfiguration other = (LocalStorageConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isUseTempFiles() != other.isUseTempFiles()) {
            return false;
        }
        if (this.isKeepFileName() != other.isKeepFileName()) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocalStorageConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isUseTempFiles() ? 79 : 97);
        result = result * 59 + (this.isKeepFileName() ? 79 : 97);
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LocalStorageConfiguration(active=" + this.isActive() + ", path=" + this.getPath() + ", useTempFiles=" + this.isUseTempFiles() + ", keepFileName=" + this.isKeepFileName() + ")";
    }
}

