/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.generic.controller;

import de.frachtwerk.essencium.backend.model.exception.ResourceNotFoundException;
import de.frachtwerk.essencium.storage.generic.controller.FileNotAvailableException;
import de.frachtwerk.essencium.storage.generic.model.AbstractFile;
import de.frachtwerk.essencium.storage.generic.model.AbstractStorageInfo;
import de.frachtwerk.essencium.storage.generic.service.FileService;
import de.frachtwerk.essencium.storage.generic.service.UniqueNameCreator;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class DownloadEndpoint<F extends AbstractFile<F, ID, S>, ID extends Serializable, S extends AbstractStorageInfo<F, ID, S>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadEndpoint.class);
    private final FileService<F, ID, S> service;
    private final UniqueNameCreator uniqueNameCreator;

    @NotNull
    public ResponseEntity<Resource> prepareResponse(ID id) {
        AbstractFile file = (AbstractFile)((Object)this.service.loadFile(id).orElseThrow(() -> new ResourceNotFoundException(String.valueOf(id))));
        return this.prepareResponse(file);
    }

    @NotNull
    public ResponseEntity<Resource> prepareResponse(F file) {
        Resource resource = this.getResource(file);
        String mimeType = Optional.ofNullable(((AbstractFile)((Object)file)).getMimeType()).orElse("application/octet-stream");
        return this.buildResponse(resource, ((AbstractFile)((Object)file)).getName(), MediaType.parseMediaType((String)mimeType));
    }

    /*
     * Exception decompiling
     */
    public ResponseEntity<Resource> prepareZipResponse(String responseFileName, Collection<F> abstractFiles) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ResponseEntity<Resource> buildResponse(Resource resource, String name, MediaType contentType) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(contentType).header("Content-Disposition", new String[]{"attachment; filename=\"" + name})).body((Object)resource);
    }

    private Resource getResource(F file) {
        if (((AbstractFile)((Object)file)).isAvailable()) {
            for (AbstractStorageInfo storage : ((AbstractFile)((Object)file)).getStorageInfos()) {
                if (storage.isAvailable()) {
                    Resource resource = storage.getContent();
                    if (resource != null) {
                        if (!resource.exists()) continue;
                        return resource;
                    }
                    log.warn("File is marked available but resource is null");
                    this.service.markAsUnavailable(storage);
                    continue;
                }
                log.warn("File {} in {} is not available.", (Object)file.getId(), (Object)storage);
                this.service.markAsUnavailable(storage);
            }
        }
        throw new FileNotAvailableException("File not found");
    }

    @Generated
    public DownloadEndpoint(FileService<F, ID, S> service, UniqueNameCreator uniqueNameCreator) {
        this.service = service;
        this.uniqueNameCreator = uniqueNameCreator;
    }
}

