/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.generic.service;

import de.frachtwerk.essencium.storage.generic.configuration.FileStorageConfiguration;
import de.frachtwerk.essencium.storage.generic.model.AbstractFile;
import de.frachtwerk.essencium.storage.generic.model.AbstractStorageInfo;
import de.frachtwerk.essencium.storage.generic.model.Providers;
import de.frachtwerk.essencium.storage.generic.model.StorageInfoVisitor;
import de.frachtwerk.essencium.storage.generic.provider.local.AbstractLocalStorageInfo;
import de.frachtwerk.essencium.storage.generic.provider.local.AbstractLocalStorageService;
import de.frachtwerk.essencium.storage.generic.provider.s3.AbstractS3StorageInfo;
import de.frachtwerk.essencium.storage.generic.provider.s3.AbstractS3StorageService;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class StorageServiceDispatcher<F extends AbstractFile<F, ID, S>, ID extends Serializable, S extends AbstractStorageInfo<F, ID, S>> {
    @Nullable
    private final AbstractLocalStorageService<F, ID, S> local;
    @Nullable
    private final AbstractS3StorageService<F, ID, S> s3;
    private final FileStorageConfiguration config;

    public List<S> saveFile(String originalName, byte[] content) throws IOException {
        ArrayList<S> infos = new ArrayList<S>();
        block4: for (Providers provider : this.config.getUsedProviders()) {
            switch (provider) {
                case LOCAL: {
                    infos.add(Objects.requireNonNull(this.local).saveFile(originalName, content));
                    continue block4;
                }
                case S3: {
                    infos.add(Objects.requireNonNull(this.s3).saveFile(originalName, content));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unknown provider");
        }
        return infos;
    }

    public boolean deleteFile(S info) {
        return ((AbstractStorageInfo)((Object)info)).accept(new StorageInfoVisitor<Boolean, F, ID, S>(){

            @Override
            public Boolean visit(AbstractLocalStorageInfo<F, ID, S> info) {
                return Objects.requireNonNull(StorageServiceDispatcher.this.local).deleteFile((AbstractStorageInfo)((Object)info));
            }

            @Override
            public Boolean visit(AbstractS3StorageInfo<F, ID, S> info) {
                return Objects.requireNonNull(StorageServiceDispatcher.this.s3).deleteFile((AbstractStorageInfo)((Object)info));
            }
        });
    }

    public S loadFile(S info) {
        return (S)((Object)((AbstractStorageInfo)((Object)((AbstractStorageInfo)((Object)info)).accept(new StorageInfoVisitor<S, F, ID, S>(){

            @Override
            public S visit(AbstractLocalStorageInfo<F, ID, S> info) {
                return (Object)Objects.requireNonNull(StorageServiceDispatcher.this.local).loadFile((AbstractStorageInfo)((Object)info));
            }

            @Override
            public S visit(AbstractS3StorageInfo<F, ID, S> info) {
                return (Object)Objects.requireNonNull(StorageServiceDispatcher.this.s3).loadFile((AbstractStorageInfo)((Object)info));
            }
        }))));
    }

    public StorageServiceDispatcher(@Nullable AbstractLocalStorageService<F, ID, S> local, @Nullable AbstractS3StorageService<F, ID, S> s3, FileStorageConfiguration config) {
        this.local = local;
        this.s3 = s3;
        this.config = config;
    }
}

