/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.generic.service;

import de.frachtwerk.essencium.storage.generic.model.AbstractFile;
import de.frachtwerk.essencium.storage.generic.model.AbstractStorageInfo;
import de.frachtwerk.essencium.storage.generic.repository.AbstractFileRepository;
import de.frachtwerk.essencium.storage.generic.service.FileService;
import de.frachtwerk.essencium.storage.generic.service.MimeTypeHelper;
import de.frachtwerk.essencium.storage.generic.service.StorageServiceDispatcher;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CachePut;
import org.springframework.data.jpa.domain.Specification;

public abstract class AbstractFileService<F extends AbstractFile<F, ID, S>, ID extends Serializable, S extends AbstractStorageInfo<F, ID, S>>
implements FileService<F, ID, S> {
    private final Logger LOG = LoggerFactory.getLogger(AbstractFileService.class);
    private final StorageServiceDispatcher<F, ID, S> dispatcher;
    private final AbstractFileRepository<F, ID, S> repository;
    private final MimeTypeHelper mimeTypeHelper;

    @Override
    public F storeFile(String name, String mimeType, byte[] fileContent) throws IOException {
        List<S> infos = this.dispatcher.saveFile(name, fileContent);
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            this.LOG.debug("MIME Type not set. Attempting to determine it...");
            mimeType = this.mimeTypeHelper.getMimeType(name, fileContent);
        }
        Object file = this.getNewFile(infos, name, fileContent.length, mimeType);
        infos.forEach(i -> i.setFile(file));
        return (F)((Object)((AbstractFile)((Object)this.repository.save(file))));
    }

    protected abstract F getNewFile(List<S> var1, String var2, int var3, String var4);

    @Override
    public Optional<F> loadFile(ID id) {
        return this.repository.findById(id).map(this::loadFromProviders);
    }

    @Override
    @NotNull
    public List<F> getAll() {
        List allEntities = this.repository.findAll();
        allEntities.forEach(this::loadFromProviders);
        return allEntities;
    }

    @Override
    @NotNull
    public List<F> getAllFiltered(Specification<F> specification) {
        List result = this.repository.findAll(specification);
        result.forEach(this::loadFromProviders);
        return result;
    }

    @Override
    @NotNull
    public F loadFromProviders(@NotNull F f) {
        for (AbstractStorageInfo info : ((AbstractFile)((Object)f)).getStorageInfos()) {
            if (!info.isAvailable()) continue;
            this.dispatcher.loadFile(info);
            if (info.getContent() != null) break;
            if (info.isAvailable()) continue;
            this.markAsUnavailable(info);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFile(ID id) {
        Optional file = this.repository.findById(id);
        try {
            boolean bl = file.map(f -> f.getStorageInfos().stream().map(this.dispatcher::deleteFile).reduce(true, (acc, v) -> acc != false && v != false)).orElse(false);
            return bl;
        }
        finally {
            if (file.isPresent()) {
                this.repository.delete((Object)((AbstractFile)((Object)file.get())));
                this.LOG.debug("Deleted file {}.", id);
            }
        }
    }

    @Override
    @CachePut(value={"files"}, key="#result.id")
    public void markAsUnavailable(S info) {
        this.LOG.debug("Mark storage {} of file {} as unavailable.", (Object)((AbstractStorageInfo)((Object)info)).getFile().getId(), (Object)info.getId());
        ((AbstractStorageInfo)((Object)info)).setAvailable(false);
        this.repository.save(((AbstractStorageInfo)((Object)info)).getFile());
    }

    public AbstractFileService(StorageServiceDispatcher<F, ID, S> dispatcher, AbstractFileRepository<F, ID, S> repository, MimeTypeHelper mimeTypeHelper) {
        this.dispatcher = dispatcher;
        this.repository = repository;
        this.mimeTypeHelper = mimeTypeHelper;
    }
}

