/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.generic.provider.local;

import de.frachtwerk.essencium.storage.generic.model.AbstractFile;
import de.frachtwerk.essencium.storage.generic.model.AbstractStorageInfo;
import de.frachtwerk.essencium.storage.generic.model.Providers;
import de.frachtwerk.essencium.storage.generic.provider.local.AbstractLocalStorageInfo;
import de.frachtwerk.essencium.storage.generic.provider.local.LocalFileCreator;
import de.frachtwerk.essencium.storage.generic.provider.local.LocalStorageConfiguration;
import de.frachtwerk.essencium.storage.generic.service.StorageService;
import de.frachtwerk.essencium.storage.generic.service.UniqueNameCreator;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class AbstractLocalStorageService<F extends AbstractFile<F, ID, S>, ID extends Serializable, S extends AbstractStorageInfo<F, ID, S>>
implements StorageService<F, ID, S> {
    private final Logger LOG = LoggerFactory.getLogger(AbstractLocalStorageService.class);
    @NotNull
    private final LocalFileCreator fileCreator;
    @NotNull
    private final LocalStorageConfiguration config;
    @NotNull
    private final UniqueNameCreator uniqueNameCreator;

    @Override
    public final S saveFile(String originalName, byte[] content) throws IOException {
        String name;
        if (originalName != null && this.config.isKeepFileName()) {
            name = this.uniqueNameCreator.getUniqueName(originalName, this::exists);
        } else {
            while (new File(name = UUID.randomUUID().toString()).exists()) {
            }
        }
        File f = this.fileCreator.createFile(name);
        Files.write(f.toPath(), content, new OpenOption[0]);
        String path = f.getAbsolutePath();
        this.LOG.debug("Saved file at {}.", (Object)path);
        AbstractStorageInfo info = (AbstractStorageInfo)((Object)this.getNewLocalStorageInfo(null, path));
        info.setContent((Resource)new FileSystemResource(f));
        return (S)((Object)info);
    }

    protected abstract <SI extends AbstractLocalStorageInfo<F, ID, S>> SI getNewLocalStorageInfo(F var1, String var2);

    private boolean exists(String name) {
        Path path = Path.of(this.config.resolvePath().toString(), name);
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    public final boolean deleteFile(S abstractInfo) {
        AbstractLocalStorageInfo info = (AbstractLocalStorageInfo)abstractInfo;
        return new File(info.getPath()).delete();
    }

    @Override
    public final S loadFile(S abstractInfo) {
        AbstractLocalStorageInfo info = (AbstractLocalStorageInfo)abstractInfo;
        File file = new File(info.getPath());
        if (!file.exists()) {
            this.LOG.warn("File {} with name {} is not present on disk.", (Object)info.getFile().getId(), (Object)Path.of(info.getPath(), new String[0]).getFileName());
            info.setAvailable(false);
        } else {
            info.setContent((Resource)new FileSystemResource(file));
        }
        return (S)((Object)((AbstractStorageInfo)((Object)info)));
    }

    @Override
    public Providers getType() {
        return Providers.LOCAL;
    }

    public AbstractLocalStorageService(LocalFileCreator fileCreator, LocalStorageConfiguration config, UniqueNameCreator uniqueNameCreator) {
        this.fileCreator = fileCreator;
        this.config = config;
        this.uniqueNameCreator = uniqueNameCreator;
    }
}

