/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.generic.provider.local;

import de.frachtwerk.essencium.storage.generic.provider.local.LocalStorageConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class LocalFileCreator {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileCreator.class);
    private final LocalStorageConfiguration config;

    @EventListener(value={ApplicationReadyEvent.class})
    public void init() throws IOException {
        Path path;
        if (this.config.isActive() && !this.config.isUseTempFiles() && !Files.exists(path = this.config.resolvePath(), new LinkOption[0])) {
            LOG.debug("Directory {} for storing files does not exist.", (Object)path);
            Files.createDirectories(path, new FileAttribute[0]);
            LOG.info("Created directory for file storing.");
        }
    }

    public File createFile(String name) throws IOException {
        if (this.config.isUseTempFiles()) {
            return File.createTempFile(name, null);
        }
        Path pre = Path.of(this.config.resolvePath().toString(), name);
        Path path = Files.createFile(pre, new FileAttribute[0]);
        return path.toFile();
    }

    public LocalFileCreator(LocalStorageConfiguration config) {
        this.config = config;
    }
}

