/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.generic.model;

import de.frachtwerk.essencium.backend.model.AbstractBaseModel;
import de.frachtwerk.essencium.storage.generic.model.AbstractStorageInfo;
import jakarta.persistence.CascadeType;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@MappedSuperclass
public abstract class AbstractFile<F extends AbstractFile<F, ID, S>, ID extends Serializable, S extends AbstractStorageInfo<F, ID, S>>
extends AbstractBaseModel<ID> {
    private String name;
    private long size;
    private String mimeType;

    @NotNull
    @OrderColumn
    @OneToMany(cascade={CascadeType.ALL})
    public abstract List<S> getStorageInfos();

    public abstract boolean isAvailable();

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String toString() {
        return "AbstractFile(name=" + this.getName() + ", size=" + this.getSize() + ", mimeType=" + this.getMimeType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractFile)) {
            return false;
        }
        AbstractFile other = (AbstractFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mimeType = this.getMimeType();
        String other$mimeType = other.getMimeType();
        return !(this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        return result;
    }

    public AbstractFile() {
    }

    public AbstractFile(String name, long size, String mimeType) {
        this.name = name;
        this.size = size;
        this.mimeType = mimeType;
    }
}

