/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.generic.provider.s3;

import de.frachtwerk.essencium.storage.generic.model.AbstractFile;
import de.frachtwerk.essencium.storage.generic.model.AbstractStorageInfo;
import de.frachtwerk.essencium.storage.generic.model.Providers;
import de.frachtwerk.essencium.storage.generic.provider.s3.AbstractS3StorageInfo;
import de.frachtwerk.essencium.storage.generic.provider.s3.S3StorageConfiguration;
import de.frachtwerk.essencium.storage.generic.service.MimeTypeHelper;
import de.frachtwerk.essencium.storage.generic.service.StorageService;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Object;

public abstract class AbstractS3StorageService<F extends AbstractFile<F, ID, S>, ID extends Serializable, S extends AbstractStorageInfo<F, ID, S>>
implements StorageService<F, ID, S> {
    private final Logger LOG = LoggerFactory.getLogger(AbstractS3StorageService.class);
    @NotNull
    private final S3StorageConfiguration config;
    private final MimeTypeHelper mimeTypeHelper;

    public AbstractS3StorageService(@NotNull S3StorageConfiguration config, MimeTypeHelper mimeTypeHelper) {
        this.config = config;
        this.mimeTypeHelper = mimeTypeHelper;
    }

    private S3Client getClient() {
        AwsCredentialsProvider credentialProvider = this.getCredentialProvider();
        S3ClientBuilder builder = (S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(credentialProvider)).region(this.getRegion(this.config.getRegion()));
        if (StringUtils.isNotBlank((CharSequence)this.config.getEndpointUrl())) {
            this.LOG.debug("Using custom endpoint: {}", (Object)this.config.getEndpointUrl());
            ((S3ClientBuilder)builder.endpointOverride(URI.create(this.config.getEndpointUrl()))).forcePathStyle(Boolean.valueOf(true));
        }
        return (S3Client)builder.build();
    }

    private AwsCredentialsProvider getCredentialProvider() {
        if (StringUtils.isNotBlank((CharSequence)this.config.getEndpointUrl()) && StringUtils.isNotBlank((CharSequence)this.config.getAccessKey()) && StringUtils.isNotBlank((CharSequence)this.config.getSecretKey())) {
            this.LOG.debug("Using custom credentials provider");
            AwsBasicCredentials awsCredentials = AwsBasicCredentials.create((String)this.config.getAccessKey(), (String)this.config.getSecretKey());
            return StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        }
        this.LOG.debug("Using default credentials provider");
        DefaultCredentialsProvider defaultCredentialsProvider = DefaultCredentialsProvider.create();
        this.LOG.debug("DefaultCredentialsProvider, accessKeyId: {}", (Object)defaultCredentialsProvider.resolveCredentials().accessKeyId());
        return defaultCredentialsProvider;
    }

    private Region getRegion(@Nullable String region) {
        if (StringUtils.isNotBlank((CharSequence)region)) {
            return Region.of((String)region);
        }
        return Region.EU_CENTRAL_1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final S saveFile(String originalName, byte[] content) throws IOException {
        this.LOG.debug("Saving file {} to S3 (saveFile())", (Object)originalName);
        try (S3Client s3 = this.getClient();){
            this.testBucketAccess(s3, this.config.getBucketName());
            String s3ObjectKey = this.getNewObjectKey(s3, this.config.getBucketName());
            PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.config.getBucketName()).key(s3ObjectKey).contentType(this.mimeTypeHelper.getMimeType(s3ObjectKey, content)).contentLength(Long.valueOf(content.length)).build();
            PutObjectResponse putObjectResponse = s3.putObject(putObjectRequest, RequestBody.fromBytes((byte[])content));
            this.LOG.debug("S3: PutObjectResponse: {}", (Object)putObjectResponse);
            this.LOG.info("S3: {} has been uploaded successfully", (Object)s3ObjectKey);
            AbstractStorageInfo info = (AbstractStorageInfo)((Object)this.getNewAbstractS3StorageInfo(null, s3ObjectKey));
            info.setContent((Resource)new InputStreamResource((InputStream)new ByteArrayInputStream(content)));
            AbstractStorageInfo abstractStorageInfo = info;
            return (S)((Object)abstractStorageInfo);
        }
        catch (Exception e) {
            this.LOG.error("Error saving file to S3", (Throwable)e);
            throw e;
        }
    }

    protected abstract <SI extends AbstractS3StorageInfo<F, ID, S>> SI getNewAbstractS3StorageInfo(F var1, String var2);

    @Override
    public final boolean deleteFile(S abstractInfo) {
        boolean bl;
        block8: {
            AbstractS3StorageInfo info = (AbstractS3StorageInfo)abstractInfo;
            S3Client s3 = this.getClient();
            try {
                this.testBucketAccess(s3, this.config.getBucketName());
                this.LOG.info("S3: Deleting object {}", (Object)info.getS3ObjectKey());
                DeleteObjectsRequest deleteObjectsRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.config.getBucketName()).delete((Delete)Delete.builder().objects(List.of((ObjectIdentifier)ObjectIdentifier.builder().key(info.getS3ObjectKey()).build())).build()).build();
                s3.deleteObjects(deleteObjectsRequest);
                this.LOG.info("S3: Object {} has been deleted successfully", (Object)info.getS3ObjectKey());
                bl = true;
                if (s3 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s3 != null) {
                        try {
                            s3.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.LOG.error("Error deleting file from S3", (Throwable)e);
                    throw e;
                }
            }
            s3.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final S loadFile(S abstractInfo) {
        AbstractS3StorageInfo info = (AbstractS3StorageInfo)abstractInfo;
        try (S3Client s3 = this.getClient();){
            this.testBucketAccess(s3, this.config.getBucketName());
            GetObjectRequest objectRequest = (GetObjectRequest)GetObjectRequest.builder().key(info.getS3ObjectKey()).bucket(this.config.getBucketName()).build();
            info.setContent((Resource)new ByteArrayResource(s3.getObjectAsBytes(objectRequest).asByteArray()));
            AbstractStorageInfo abstractStorageInfo = (AbstractStorageInfo)((Object)info);
            return (S)((Object)abstractStorageInfo);
        }
        catch (Exception e) {
            this.LOG.error("Error loading file from S3", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Providers getType() {
        return Providers.S3;
    }

    public void testBucketAccess(S3Client s3, String bucketName) {
        HeadBucketRequest headBucketRequest = (HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build();
        HeadBucketResponse headBucketResponse = s3.headBucket(headBucketRequest);
        this.LOG.debug("S3: HeadBucketResponse: {}", (Object)headBucketResponse.responseMetadata());
        this.LOG.debug("S3: Bucket {} exists", (Object)bucketName);
    }

    private String getNewObjectKey(S3Client s3, @NotNull @NotBlank String bucketName) {
        String s3ObjectKey;
        ListObjectsV2Request listObjectsV2Request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucketName).build();
        ListObjectsV2Response listObjectsV2Response = s3.listObjectsV2(listObjectsV2Request);
        this.LOG.debug("S3: Bucket {} contains {} object keys", (Object)bucketName, (Object)listObjectsV2Response.keyCount());
        List<String> existingKeys = listObjectsV2Response.contents().stream().map(S3Object::key).toList();
        while (existingKeys.contains(s3ObjectKey = UUID.randomUUID().toString())) {
        }
        return s3ObjectKey;
    }
}

