/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.storage.generic.model;

import de.frachtwerk.essencium.storage.generic.model.AbstractFile;
import de.frachtwerk.essencium.storage.generic.model.AbstractStorageInfo;
import de.frachtwerk.essencium.storage.generic.provider.local.AbstractLocalStorageInfo;
import de.frachtwerk.essencium.storage.generic.provider.s3.AbstractS3StorageInfo;
import java.io.Serializable;
import java.util.function.Function;

public interface StorageInfoVisitor<T, F extends AbstractFile<F, ID, S>, ID extends Serializable, S extends AbstractStorageInfo<F, ID, S>> {
    public T visit(AbstractLocalStorageInfo<F, ID, S> var1);

    public T visit(AbstractS3StorageInfo<F, ID, S> var1);

    public static <T, F extends AbstractFile<F, ID, S>, ID extends Serializable, S extends AbstractStorageInfo<F, ID, S>> StorageInfoVisitor<T, F, ID, S> local(final Function<AbstractLocalStorageInfo<F, ID, S>, T> visitor) {
        return new Empty<T, F, ID, S>(){

            @Override
            public T visit(AbstractLocalStorageInfo<F, ID, S> info) {
                return visitor.apply(info);
            }
        };
    }

    public static <T, F extends AbstractFile<F, ID, S>, ID extends Serializable, S extends AbstractStorageInfo<F, ID, S>> StorageInfoVisitor<T, F, ID, S> s3(final Function<AbstractS3StorageInfo<F, ID, S>, T> visitor) {
        return new Empty<T, F, ID, S>(){

            @Override
            public T visit(AbstractS3StorageInfo<F, ID, S> info) {
                return visitor.apply(info);
            }
        };
    }

    public static class Empty<T, F extends AbstractFile<F, ID, S>, ID extends Serializable, S extends AbstractStorageInfo<F, ID, S>>
    implements StorageInfoVisitor<T, F, ID, S> {
        @Override
        public T visit(AbstractLocalStorageInfo<F, ID, S> info) {
            return null;
        }

        @Override
        public T visit(AbstractS3StorageInfo<F, ID, S> info) {
            return null;
        }
    }
}

