/*
 * Decompiled with CFR 0.152.
 */
package de.foryasee.plugins.loader.impl;

import de.foryasee.plugins.Plugin;
import de.foryasee.plugins.exceptions.InvalidPluginException;
import de.foryasee.plugins.loader.IPluginLoader;
import de.foryasee.plugins.loader.PluginLoadedResult;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class PluginLoader
implements IPluginLoader {
    @Override
    public <T extends Plugin> CompletableFuture<PluginLoadedResult<T>> load(File file) {
        Objects.requireNonNull(file);
        return CompletableFuture.supplyAsync(() -> {
            Plugin plugin;
            try {
                this.checkFile(file);
                ClassLoader classLoader = this.getClassLoader(file);
                Set<Class<?>> classes = this.getClassesFromJar(file, classLoader);
                Class clazz = this.getPluginClass(file, classes);
                plugin = (Plugin)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e2) {
                InvalidPluginException e2;
                if (!(e2 instanceof InvalidPluginException)) {
                    e2 = new InvalidPluginException(file, (Throwable)e2);
                }
                return new PluginLoadedResult<Object>(null, e2);
            }
            return new PluginLoadedResult<Plugin>(plugin, null);
        });
    }

    private ClassLoader getClassLoader(File file) throws InvalidPluginException {
        try {
            return new URLClassLoader(new URL[]{file.toURI().toURL()});
        }
        catch (MalformedURLException e) {
            throw new InvalidPluginException(file, (Throwable)e);
        }
    }

    private Set<Class<?>> getClassesFromJar(File file, ClassLoader classLoader) throws InvalidPluginException {
        HashSet classes = new HashSet();
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (!jarEntry.getName().toLowerCase().endsWith(".class")) continue;
                classes.add(classLoader.loadClass(jarEntry.getName().substring(0, jarEntry.getName().length() - 6).replace("/", ".")));
            }
        }
        catch (Exception e) {
            throw new InvalidPluginException(file, (Throwable)e);
        }
        return classes;
    }

    private <T> Class<T> getPluginClass(File file, Set<Class<?>> classes) throws InvalidPluginException {
        ArrayList pluginClasses = new ArrayList();
        classes.forEach(clazz -> {
            if (!Plugin.class.isAssignableFrom((Class<?>)clazz) || Modifier.isAbstract(clazz.getModifiers())) {
                return;
            }
            System.out.println(clazz.getName());
            try {
                pluginClasses.add(clazz);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
        if (pluginClasses.isEmpty()) {
            throw new InvalidPluginException(file, "contains no Plugin class.");
        }
        if (pluginClasses.size() > 1) {
            throw new InvalidPluginException(file, "contains multiple Plugin classes");
        }
        return (Class)pluginClasses.get(0);
    }

    private void checkFile(File file) throws InvalidPluginException {
        if (!file.exists()) {
            throw new InvalidPluginException(file, "does not exist.");
        }
        if (!file.isFile()) {
            throw new InvalidPluginException(file, "is not a file.");
        }
        if (!file.getName().endsWith(".jar")) {
            throw new InvalidPluginException(file, "is not a .jar file.");
        }
    }
}

