/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.lexoffice.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.focus_shift.lexoffice.java.sdk.model.Address;
import de.focus_shift.lexoffice.java.sdk.model.Files;
import de.focus_shift.lexoffice.java.sdk.model.LineItem;
import de.focus_shift.lexoffice.java.sdk.model.PaymentConditions;
import de.focus_shift.lexoffice.java.sdk.model.ShippingConditions;
import de.focus_shift.lexoffice.java.sdk.model.TaxAmount;
import de.focus_shift.lexoffice.java.sdk.model.TaxConditions;
import de.focus_shift.lexoffice.java.sdk.model.TotalPrice;
import de.focus_shift.lexoffice.java.sdk.model.VoucherStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Invoice {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="organizationId")
    private String organizationId;
    @JsonProperty(value="createdDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date createdDate;
    @JsonProperty(value="updatedDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date updatedDate;
    @JsonProperty(value="version")
    private Long version;
    @JsonProperty(value="language")
    private String language;
    @JsonProperty(value="archived")
    private boolean archived;
    @JsonProperty(value="voucherStatus")
    private VoucherStatus voucherStatus;
    @JsonProperty(value="voucherNumber")
    private String voucherNumber;
    @JsonProperty(value="voucherDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date voucherDate;
    @JsonProperty(value="dueDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date dueDate;
    @JsonProperty(value="address")
    private Address address;
    @JsonProperty(value="lineItems")
    private List<LineItem> lineItems;
    @JsonProperty(value="totalPrice")
    private TotalPrice totalPrice;
    @JsonProperty(value="taxAmounts")
    private List<TaxAmount> taxAmounts;
    @JsonProperty(value="taxConditions")
    private TaxConditions taxConditions;
    @JsonProperty(value="paymentConditions")
    private PaymentConditions paymentConditions;
    @JsonProperty(value="shippingConditions")
    private ShippingConditions shippingConditions;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="introduction")
    private String introduction;
    @JsonProperty(value="remark")
    private String remark;
    @JsonProperty(value="files")
    private Files files;

    public static InvoiceBuilder builder() {
        return new InvoiceBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public VoucherStatus getVoucherStatus() {
        return this.voucherStatus;
    }

    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    public Date getVoucherDate() {
        return this.voucherDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Address getAddress() {
        return this.address;
    }

    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public TotalPrice getTotalPrice() {
        return this.totalPrice;
    }

    public List<TaxAmount> getTaxAmounts() {
        return this.taxAmounts;
    }

    public TaxConditions getTaxConditions() {
        return this.taxConditions;
    }

    public PaymentConditions getPaymentConditions() {
        return this.paymentConditions;
    }

    public ShippingConditions getShippingConditions() {
        return this.shippingConditions;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public String getRemark() {
        return this.remark;
    }

    public Files getFiles() {
        return this.files;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="organizationId")
    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    @JsonProperty(value="createdDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @JsonProperty(value="updatedDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    @JsonProperty(value="version")
    public void setVersion(Long version) {
        this.version = version;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @JsonProperty(value="archived")
    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    @JsonProperty(value="voucherStatus")
    public void setVoucherStatus(VoucherStatus voucherStatus) {
        this.voucherStatus = voucherStatus;
    }

    @JsonProperty(value="voucherNumber")
    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    @JsonProperty(value="voucherDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    public void setVoucherDate(Date voucherDate) {
        this.voucherDate = voucherDate;
    }

    @JsonProperty(value="dueDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @JsonProperty(value="address")
    public void setAddress(Address address) {
        this.address = address;
    }

    @JsonProperty(value="lineItems")
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    @JsonProperty(value="totalPrice")
    public void setTotalPrice(TotalPrice totalPrice) {
        this.totalPrice = totalPrice;
    }

    @JsonProperty(value="taxAmounts")
    public void setTaxAmounts(List<TaxAmount> taxAmounts) {
        this.taxAmounts = taxAmounts;
    }

    @JsonProperty(value="taxConditions")
    public void setTaxConditions(TaxConditions taxConditions) {
        this.taxConditions = taxConditions;
    }

    @JsonProperty(value="paymentConditions")
    public void setPaymentConditions(PaymentConditions paymentConditions) {
        this.paymentConditions = paymentConditions;
    }

    @JsonProperty(value="shippingConditions")
    public void setShippingConditions(ShippingConditions shippingConditions) {
        this.shippingConditions = shippingConditions;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="introduction")
    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    @JsonProperty(value="remark")
    public void setRemark(String remark) {
        this.remark = remark;
    }

    @JsonProperty(value="files")
    public void setFiles(Files files) {
        this.files = files;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isArchived() != other.isArchived()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        Date this$createdDate = this.getCreatedDate();
        Date other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Date this$updatedDate = this.getUpdatedDate();
        Date other$updatedDate = other.getUpdatedDate();
        if (this$updatedDate == null ? other$updatedDate != null : !((Object)this$updatedDate).equals(other$updatedDate)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        VoucherStatus this$voucherStatus = this.getVoucherStatus();
        VoucherStatus other$voucherStatus = other.getVoucherStatus();
        if (this$voucherStatus == null ? other$voucherStatus != null : !((Object)((Object)this$voucherStatus)).equals((Object)other$voucherStatus)) {
            return false;
        }
        String this$voucherNumber = this.getVoucherNumber();
        String other$voucherNumber = other.getVoucherNumber();
        if (this$voucherNumber == null ? other$voucherNumber != null : !this$voucherNumber.equals(other$voucherNumber)) {
            return false;
        }
        Date this$voucherDate = this.getVoucherDate();
        Date other$voucherDate = other.getVoucherDate();
        if (this$voucherDate == null ? other$voucherDate != null : !((Object)this$voucherDate).equals(other$voucherDate)) {
            return false;
        }
        Date this$dueDate = this.getDueDate();
        Date other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        List<LineItem> this$lineItems = this.getLineItems();
        List<LineItem> other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        TotalPrice this$totalPrice = this.getTotalPrice();
        TotalPrice other$totalPrice = other.getTotalPrice();
        if (this$totalPrice == null ? other$totalPrice != null : !((Object)this$totalPrice).equals(other$totalPrice)) {
            return false;
        }
        List<TaxAmount> this$taxAmounts = this.getTaxAmounts();
        List<TaxAmount> other$taxAmounts = other.getTaxAmounts();
        if (this$taxAmounts == null ? other$taxAmounts != null : !((Object)this$taxAmounts).equals(other$taxAmounts)) {
            return false;
        }
        TaxConditions this$taxConditions = this.getTaxConditions();
        TaxConditions other$taxConditions = other.getTaxConditions();
        if (this$taxConditions == null ? other$taxConditions != null : !((Object)this$taxConditions).equals(other$taxConditions)) {
            return false;
        }
        PaymentConditions this$paymentConditions = this.getPaymentConditions();
        PaymentConditions other$paymentConditions = other.getPaymentConditions();
        if (this$paymentConditions == null ? other$paymentConditions != null : !((Object)this$paymentConditions).equals(other$paymentConditions)) {
            return false;
        }
        ShippingConditions this$shippingConditions = this.getShippingConditions();
        ShippingConditions other$shippingConditions = other.getShippingConditions();
        if (this$shippingConditions == null ? other$shippingConditions != null : !((Object)this$shippingConditions).equals(other$shippingConditions)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$introduction = this.getIntroduction();
        String other$introduction = other.getIntroduction();
        if (this$introduction == null ? other$introduction != null : !this$introduction.equals(other$introduction)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        Files this$files = this.getFiles();
        Files other$files = other.getFiles();
        return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Invoice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isArchived() ? 79 : 97);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        Date $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Date $updatedDate = this.getUpdatedDate();
        result = result * 59 + ($updatedDate == null ? 43 : ((Object)$updatedDate).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        VoucherStatus $voucherStatus = this.getVoucherStatus();
        result = result * 59 + ($voucherStatus == null ? 43 : ((Object)((Object)$voucherStatus)).hashCode());
        String $voucherNumber = this.getVoucherNumber();
        result = result * 59 + ($voucherNumber == null ? 43 : $voucherNumber.hashCode());
        Date $voucherDate = this.getVoucherDate();
        result = result * 59 + ($voucherDate == null ? 43 : ((Object)$voucherDate).hashCode());
        Date $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        List<LineItem> $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        TotalPrice $totalPrice = this.getTotalPrice();
        result = result * 59 + ($totalPrice == null ? 43 : ((Object)$totalPrice).hashCode());
        List<TaxAmount> $taxAmounts = this.getTaxAmounts();
        result = result * 59 + ($taxAmounts == null ? 43 : ((Object)$taxAmounts).hashCode());
        TaxConditions $taxConditions = this.getTaxConditions();
        result = result * 59 + ($taxConditions == null ? 43 : ((Object)$taxConditions).hashCode());
        PaymentConditions $paymentConditions = this.getPaymentConditions();
        result = result * 59 + ($paymentConditions == null ? 43 : ((Object)$paymentConditions).hashCode());
        ShippingConditions $shippingConditions = this.getShippingConditions();
        result = result * 59 + ($shippingConditions == null ? 43 : ((Object)$shippingConditions).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $introduction = this.getIntroduction();
        result = result * 59 + ($introduction == null ? 43 : $introduction.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        Files $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        return result;
    }

    public String toString() {
        return "Invoice(id=" + this.getId() + ", organizationId=" + this.getOrganizationId() + ", createdDate=" + this.getCreatedDate() + ", updatedDate=" + this.getUpdatedDate() + ", version=" + this.getVersion() + ", language=" + this.getLanguage() + ", archived=" + this.isArchived() + ", voucherStatus=" + this.getVoucherStatus() + ", voucherNumber=" + this.getVoucherNumber() + ", voucherDate=" + this.getVoucherDate() + ", dueDate=" + this.getDueDate() + ", address=" + this.getAddress() + ", lineItems=" + this.getLineItems() + ", totalPrice=" + this.getTotalPrice() + ", taxAmounts=" + this.getTaxAmounts() + ", taxConditions=" + this.getTaxConditions() + ", paymentConditions=" + this.getPaymentConditions() + ", shippingConditions=" + this.getShippingConditions() + ", title=" + this.getTitle() + ", introduction=" + this.getIntroduction() + ", remark=" + this.getRemark() + ", files=" + this.getFiles() + ")";
    }

    public Invoice(String id, String organizationId, Date createdDate, Date updatedDate, Long version, String language, boolean archived, VoucherStatus voucherStatus, String voucherNumber, Date voucherDate, Date dueDate, Address address, List<LineItem> lineItems, TotalPrice totalPrice, List<TaxAmount> taxAmounts, TaxConditions taxConditions, PaymentConditions paymentConditions, ShippingConditions shippingConditions, String title, String introduction, String remark, Files files) {
        this.id = id;
        this.organizationId = organizationId;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
        this.version = version;
        this.language = language;
        this.archived = archived;
        this.voucherStatus = voucherStatus;
        this.voucherNumber = voucherNumber;
        this.voucherDate = voucherDate;
        this.dueDate = dueDate;
        this.address = address;
        this.lineItems = lineItems;
        this.totalPrice = totalPrice;
        this.taxAmounts = taxAmounts;
        this.taxConditions = taxConditions;
        this.paymentConditions = paymentConditions;
        this.shippingConditions = shippingConditions;
        this.title = title;
        this.introduction = introduction;
        this.remark = remark;
        this.files = files;
    }

    public Invoice() {
    }

    public static class InvoiceBuilder {
        private String id;
        private String organizationId;
        private Date createdDate;
        private Date updatedDate;
        private Long version;
        private String language;
        private boolean archived;
        private VoucherStatus voucherStatus;
        private String voucherNumber;
        private Date voucherDate;
        private Date dueDate;
        private Address address;
        private ArrayList<LineItem> lineItems;
        private TotalPrice totalPrice;
        private ArrayList<TaxAmount> taxAmounts;
        private TaxConditions taxConditions;
        private PaymentConditions paymentConditions;
        private ShippingConditions shippingConditions;
        private String title;
        private String introduction;
        private String remark;
        private Files files;

        InvoiceBuilder() {
        }

        @JsonProperty(value="id")
        public InvoiceBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="organizationId")
        public InvoiceBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @JsonProperty(value="createdDate")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
        public InvoiceBuilder createdDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @JsonProperty(value="updatedDate")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
        public InvoiceBuilder updatedDate(Date updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        @JsonProperty(value="version")
        public InvoiceBuilder version(Long version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="language")
        public InvoiceBuilder language(String language) {
            this.language = language;
            return this;
        }

        @JsonProperty(value="archived")
        public InvoiceBuilder archived(boolean archived) {
            this.archived = archived;
            return this;
        }

        @JsonProperty(value="voucherStatus")
        public InvoiceBuilder voucherStatus(VoucherStatus voucherStatus) {
            this.voucherStatus = voucherStatus;
            return this;
        }

        @JsonProperty(value="voucherNumber")
        public InvoiceBuilder voucherNumber(String voucherNumber) {
            this.voucherNumber = voucherNumber;
            return this;
        }

        @JsonProperty(value="voucherDate")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
        public InvoiceBuilder voucherDate(Date voucherDate) {
            this.voucherDate = voucherDate;
            return this;
        }

        @JsonProperty(value="dueDate")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
        public InvoiceBuilder dueDate(Date dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        @JsonProperty(value="address")
        public InvoiceBuilder address(Address address) {
            this.address = address;
            return this;
        }

        public InvoiceBuilder lineItem(LineItem lineItem) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList();
            }
            this.lineItems.add(lineItem);
            return this;
        }

        @JsonProperty(value="lineItems")
        public InvoiceBuilder lineItems(Collection<? extends LineItem> lineItems) {
            if (lineItems == null) {
                throw new NullPointerException("lineItems cannot be null");
            }
            if (this.lineItems == null) {
                this.lineItems = new ArrayList();
            }
            this.lineItems.addAll(lineItems);
            return this;
        }

        public InvoiceBuilder clearLineItems() {
            if (this.lineItems != null) {
                this.lineItems.clear();
            }
            return this;
        }

        @JsonProperty(value="totalPrice")
        public InvoiceBuilder totalPrice(TotalPrice totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        public InvoiceBuilder taxAmount(TaxAmount taxAmount) {
            if (this.taxAmounts == null) {
                this.taxAmounts = new ArrayList();
            }
            this.taxAmounts.add(taxAmount);
            return this;
        }

        @JsonProperty(value="taxAmounts")
        public InvoiceBuilder taxAmounts(Collection<? extends TaxAmount> taxAmounts) {
            if (taxAmounts == null) {
                throw new NullPointerException("taxAmounts cannot be null");
            }
            if (this.taxAmounts == null) {
                this.taxAmounts = new ArrayList();
            }
            this.taxAmounts.addAll(taxAmounts);
            return this;
        }

        public InvoiceBuilder clearTaxAmounts() {
            if (this.taxAmounts != null) {
                this.taxAmounts.clear();
            }
            return this;
        }

        @JsonProperty(value="taxConditions")
        public InvoiceBuilder taxConditions(TaxConditions taxConditions) {
            this.taxConditions = taxConditions;
            return this;
        }

        @JsonProperty(value="paymentConditions")
        public InvoiceBuilder paymentConditions(PaymentConditions paymentConditions) {
            this.paymentConditions = paymentConditions;
            return this;
        }

        @JsonProperty(value="shippingConditions")
        public InvoiceBuilder shippingConditions(ShippingConditions shippingConditions) {
            this.shippingConditions = shippingConditions;
            return this;
        }

        @JsonProperty(value="title")
        public InvoiceBuilder title(String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="introduction")
        public InvoiceBuilder introduction(String introduction) {
            this.introduction = introduction;
            return this;
        }

        @JsonProperty(value="remark")
        public InvoiceBuilder remark(String remark) {
            this.remark = remark;
            return this;
        }

        @JsonProperty(value="files")
        public InvoiceBuilder files(Files files) {
            this.files = files;
            return this;
        }

        public Invoice build() {
            return new Invoice(this.id, this.organizationId, this.createdDate, this.updatedDate, this.version, this.language, this.archived, this.voucherStatus, this.voucherNumber, this.voucherDate, this.dueDate, this.address, switch (this.lineItems == null ? 0 : this.lineItems.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.lineItems.get(0));
                default -> Collections.unmodifiableList(new ArrayList<LineItem>(this.lineItems));
            }, this.totalPrice, switch (this.taxAmounts == null ? 0 : this.taxAmounts.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.taxAmounts.get(0));
                default -> Collections.unmodifiableList(new ArrayList<TaxAmount>(this.taxAmounts));
            }, this.taxConditions, this.paymentConditions, this.shippingConditions, this.title, this.introduction, this.remark, this.files);
        }

        public String toString() {
            return "Invoice.InvoiceBuilder(id=" + this.id + ", organizationId=" + this.organizationId + ", createdDate=" + this.createdDate + ", updatedDate=" + this.updatedDate + ", version=" + this.version + ", language=" + this.language + ", archived=" + this.archived + ", voucherStatus=" + this.voucherStatus + ", voucherNumber=" + this.voucherNumber + ", voucherDate=" + this.voucherDate + ", dueDate=" + this.dueDate + ", address=" + this.address + ", lineItems=" + this.lineItems + ", totalPrice=" + this.totalPrice + ", taxAmounts=" + this.taxAmounts + ", taxConditions=" + this.taxConditions + ", paymentConditions=" + this.paymentConditions + ", shippingConditions=" + this.shippingConditions + ", title=" + this.title + ", introduction=" + this.introduction + ", remark=" + this.remark + ", files=" + this.files + ")";
        }
    }
}

