/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.lexoffice.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.focus_shift.lexoffice.java.sdk.model.Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Addresses {
    @JsonProperty(value="billing")
    private List<Address> billings;
    @JsonProperty(value="shipping")
    private List<Address> shippings;

    public static AddressesBuilder builder() {
        return new AddressesBuilder();
    }

    public List<Address> getBillings() {
        return this.billings;
    }

    public List<Address> getShippings() {
        return this.shippings;
    }

    @JsonProperty(value="billing")
    public void setBillings(List<Address> billings) {
        this.billings = billings;
    }

    @JsonProperty(value="shipping")
    public void setShippings(List<Address> shippings) {
        this.shippings = shippings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Addresses)) {
            return false;
        }
        Addresses other = (Addresses)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Address> this$billings = this.getBillings();
        List<Address> other$billings = other.getBillings();
        if (this$billings == null ? other$billings != null : !((Object)this$billings).equals(other$billings)) {
            return false;
        }
        List<Address> this$shippings = this.getShippings();
        List<Address> other$shippings = other.getShippings();
        return !(this$shippings == null ? other$shippings != null : !((Object)this$shippings).equals(other$shippings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Addresses;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Address> $billings = this.getBillings();
        result = result * 59 + ($billings == null ? 43 : ((Object)$billings).hashCode());
        List<Address> $shippings = this.getShippings();
        result = result * 59 + ($shippings == null ? 43 : ((Object)$shippings).hashCode());
        return result;
    }

    public String toString() {
        return "Addresses(billings=" + this.getBillings() + ", shippings=" + this.getShippings() + ")";
    }

    public Addresses(List<Address> billings, List<Address> shippings) {
        this.billings = billings;
        this.shippings = shippings;
    }

    public Addresses() {
    }

    public static class AddressesBuilder {
        private ArrayList<Address> billings;
        private ArrayList<Address> shippings;

        AddressesBuilder() {
        }

        public AddressesBuilder billing(Address billing) {
            if (this.billings == null) {
                this.billings = new ArrayList();
            }
            this.billings.add(billing);
            return this;
        }

        @JsonProperty(value="billing")
        public AddressesBuilder billings(Collection<? extends Address> billings) {
            if (billings == null) {
                throw new NullPointerException("billings cannot be null");
            }
            if (this.billings == null) {
                this.billings = new ArrayList();
            }
            this.billings.addAll(billings);
            return this;
        }

        public AddressesBuilder clearBillings() {
            if (this.billings != null) {
                this.billings.clear();
            }
            return this;
        }

        public AddressesBuilder shipping(Address shipping) {
            if (this.shippings == null) {
                this.shippings = new ArrayList();
            }
            this.shippings.add(shipping);
            return this;
        }

        @JsonProperty(value="shipping")
        public AddressesBuilder shippings(Collection<? extends Address> shippings) {
            if (shippings == null) {
                throw new NullPointerException("shippings cannot be null");
            }
            if (this.shippings == null) {
                this.shippings = new ArrayList();
            }
            this.shippings.addAll(shippings);
            return this;
        }

        public AddressesBuilder clearShippings() {
            if (this.shippings != null) {
                this.shippings.clear();
            }
            return this;
        }

        public Addresses build() {
            return new Addresses(switch (this.billings == null ? 0 : this.billings.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.billings.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Address>(this.billings));
            }, switch (this.shippings == null ? 0 : this.shippings.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.shippings.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Address>(this.shippings));
            });
        }

        public String toString() {
            return "Addresses.AddressesBuilder(billings=" + this.billings + ", shippings=" + this.shippings + ")";
        }
    }
}

