/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.lexoffice.java.sdk.chain;

import de.focus_shift.lexoffice.java.sdk.RequestContext;
import de.focus_shift.lexoffice.java.sdk.chain.ExecutableRequestChain;
import de.focus_shift.lexoffice.java.sdk.model.ItemCreatedResult;
import de.focus_shift.lexoffice.java.sdk.model.Quotation;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;

public class QuotationChain {
    private final RequestContext context;

    public Quotation get(String id) {
        return new Get(this.context).get(id);
    }

    public Create create() {
        return new Create(this.context);
    }

    public QuotationChain(RequestContext context) {
        this.context = context;
    }

    protected static class Get
    extends ExecutableRequestChain {
        private static final ParameterizedTypeReference<Quotation> TYPE_REFERENCE = new ParameterizedTypeReference<Quotation>(){};

        public Get(RequestContext context) {
            super(context, "/quotations");
        }

        public Quotation get(String id) {
            this.getUriBuilder().appendPath("/" + id);
            return this.getContext().execute(this.getUriBuilder(), HttpMethod.GET, TYPE_REFERENCE);
        }
    }

    public static class Create
    extends ExecutableRequestChain {
        private static final ParameterizedTypeReference<ItemCreatedResult> TYPE_REFERENCE = new ParameterizedTypeReference<ItemCreatedResult>(){};

        public Create(RequestContext context) {
            super(context, "/quotations");
        }

        public Create finalize(Boolean finalize) {
            super.getUriBuilder().addParameter("finalize", finalize);
            return this;
        }

        public ItemCreatedResult submit(Quotation quotation) {
            return this.getContext().execute(this.getUriBuilder(), HttpMethod.POST, quotation, TYPE_REFERENCE);
        }
    }
}

