/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.lexoffice.java.sdk.chain;

import de.focus_shift.lexoffice.java.sdk.RequestContext;
import de.focus_shift.lexoffice.java.sdk.chain.ExecutableRequestChain;
import de.focus_shift.lexoffice.java.sdk.model.Invoice;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;

public class InvoiceChain {
    private final RequestContext context;

    public Invoice get(String id) {
        return new Get(this.context).get(id);
    }

    public Create create() {
        return new Create(this.context);
    }

    public InvoiceChain(RequestContext context) {
        this.context = context;
    }

    protected static class Get
    extends ExecutableRequestChain {
        private static final ParameterizedTypeReference<Invoice> TYPE_REFERENCE = new ParameterizedTypeReference<Invoice>(){};

        public Get(RequestContext context) {
            super(context, "/invoices");
        }

        public Invoice get(String id) {
            this.getUriBuilder().appendPath("/" + id);
            return this.getContext().execute(this.getUriBuilder(), HttpMethod.GET, TYPE_REFERENCE);
        }
    }

    public static class Create
    extends ExecutableRequestChain {
        private static final ParameterizedTypeReference<Invoice> TYPE_REFERENCE = new ParameterizedTypeReference<Invoice>(){};

        public Create(RequestContext context) {
            super(context, "/invoices");
        }

        public Create finalize(Boolean finalize) {
            super.getUriBuilder().addParameter("finalize", finalize);
            return this;
        }

        public Invoice submit(Invoice invoice) {
            return this.getContext().execute(this.getUriBuilder(), HttpMethod.POST, invoice, TYPE_REFERENCE);
        }
    }
}

