/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.lexoffice.java.sdk.chain;

import de.focus_shift.lexoffice.java.sdk.RequestContext;
import de.focus_shift.lexoffice.java.sdk.chain.ExecutableRequestChain;
import de.focus_shift.lexoffice.java.sdk.model.EventSubscription;
import de.focus_shift.lexoffice.java.sdk.model.ItemCreatedResult;
import de.focus_shift.lexoffice.java.sdk.model.Page;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;

public class EventSubscriptionChain {
    private final RequestContext context;

    public EventSubscription get(String subscriptionId) {
        return new Get(this.context).get(subscriptionId);
    }

    public List<EventSubscription> getAll() {
        return new GetAll(this.context).getAll();
    }

    public ItemCreatedResult create(EventSubscription eventSubscription) {
        return new Create(this.context).submit(eventSubscription);
    }

    public void delete(String subscriptionId) {
        new Delete(this.context).delete(subscriptionId);
    }

    public EventSubscriptionChain(RequestContext context) {
        this.context = context;
    }

    protected static class Get
    extends ExecutableRequestChain {
        private static final ParameterizedTypeReference<EventSubscription> TYPE_REFERENCE = new ParameterizedTypeReference<EventSubscription>(){};

        public Get(RequestContext context) {
            super(context, "/event-subscriptions");
        }

        public EventSubscription get(String subscriptionId) {
            this.getUriBuilder().appendPath("/" + subscriptionId);
            return this.getContext().execute(this.getUriBuilder(), HttpMethod.GET, TYPE_REFERENCE);
        }
    }

    protected static class GetAll
    extends ExecutableRequestChain {
        private static final ParameterizedTypeReference<Page<EventSubscription>> TYPE_REFERENCE = new ParameterizedTypeReference<Page<EventSubscription>>(){};

        public GetAll(RequestContext context) {
            super(context, "/event-subscriptions");
        }

        public List<EventSubscription> getAll() {
            return this.getContext().execute(this.getUriBuilder(), HttpMethod.GET, TYPE_REFERENCE).getContent();
        }
    }

    public static class Create
    extends ExecutableRequestChain {
        private static final ParameterizedTypeReference<ItemCreatedResult> TYPE_REFERENCE = new ParameterizedTypeReference<ItemCreatedResult>(){};

        public Create(RequestContext context) {
            super(context, "/event-subscriptions");
        }

        public ItemCreatedResult submit(EventSubscription eventSubscription) {
            return this.getContext().execute(this.getUriBuilder(), HttpMethod.POST, eventSubscription, TYPE_REFERENCE);
        }
    }

    protected static class Delete
    extends ExecutableRequestChain {
        public Delete(RequestContext context) {
            super(context, "/event-subscriptions");
        }

        public void delete(String subscriptionId) {
            this.getUriBuilder().appendPath("/" + subscriptionId);
            this.getContext().delete(this.getUriBuilder());
        }
    }
}

