/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.lexoffice.java.sdk.chain;

import de.focus_shift.lexoffice.java.sdk.RequestContext;
import de.focus_shift.lexoffice.java.sdk.chain.ExecutableRequestChain;
import de.focus_shift.lexoffice.java.sdk.model.Contact;
import de.focus_shift.lexoffice.java.sdk.model.ItemCreatedResult;
import de.focus_shift.lexoffice.java.sdk.model.Page;
import java.util.Objects;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;

public class ContactChain {
    private final RequestContext context;

    public Contact get(String id) {
        return new Get(this.context).get(id);
    }

    public Fetch fetch() {
        return new Fetch(this.context);
    }

    public ItemCreatedResult create(Contact contact) {
        return new Create(this.context).submit(contact);
    }

    public Contact update(Contact contact) {
        Objects.requireNonNull(contact.getId());
        return new Update(this.context).update(contact);
    }

    public ContactChain(RequestContext context) {
        this.context = context;
    }

    protected static class Get
    extends ExecutableRequestChain {
        private static final ParameterizedTypeReference<Contact> TYPE_REFERENCE = new ParameterizedTypeReference<Contact>(){};

        public Get(RequestContext context) {
            super(context, "/contacts");
        }

        public Contact get(String id) {
            this.getUriBuilder().appendPath("/" + id);
            return this.getContext().execute(this.getUriBuilder(), HttpMethod.GET, TYPE_REFERENCE);
        }
    }

    public static class Fetch
    extends ExecutableRequestChain {
        private static final ParameterizedTypeReference<Page<Contact>> TYPE_REFERENCE = new ParameterizedTypeReference<Page<Contact>>(){};

        public Fetch(RequestContext context) {
            super(context, "/contacts");
        }

        public Fetch page(int page) {
            super.getUriBuilder().addParameter("page", String.valueOf(page));
            return this;
        }

        public Fetch pageSize(int pageSize) {
            super.getUriBuilder().addParameter("size", String.valueOf(pageSize));
            return this;
        }

        public Fetch email(String email) {
            super.getUriBuilder().addParameter("email", email);
            return this;
        }

        public Fetch name(String name) {
            super.getUriBuilder().addParameter("name", name);
            return this;
        }

        public Fetch number(Long number) {
            super.getUriBuilder().addParameter("number", String.valueOf(number));
            return this;
        }

        public Fetch customer(boolean customer) {
            super.getUriBuilder().addParameter("customer", String.valueOf(customer));
            return this;
        }

        public Fetch vendor(boolean vendor) {
            super.getUriBuilder().addParameter("vendor", String.valueOf(vendor));
            return this;
        }

        public Page<Contact> get() {
            return this.getContext().execute(this.getUriBuilder(), HttpMethod.GET, TYPE_REFERENCE);
        }
    }

    public static class Create
    extends ExecutableRequestChain {
        private static final ParameterizedTypeReference<ItemCreatedResult> TYPE_REFERENCE = new ParameterizedTypeReference<ItemCreatedResult>(){};

        public Create(RequestContext context) {
            super(context, "/contacts");
        }

        public ItemCreatedResult submit(Contact contact) {
            return this.getContext().execute(this.getUriBuilder(), HttpMethod.POST, contact, TYPE_REFERENCE);
        }
    }

    public static class Update
    extends ExecutableRequestChain {
        private static final ParameterizedTypeReference<Contact> TYPE_REFERENCE = new ParameterizedTypeReference<Contact>(){};

        public Update(RequestContext context) {
            super(context, "/contacts");
        }

        public Contact update(Contact contact) {
            return this.getContext().execute(this.getUriBuilder().appendPath(contact.getId()), HttpMethod.PUT, contact, TYPE_REFERENCE);
        }
    }
}

