/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.lexoffice.java.sdk;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestUriBuilder {
    private String host;
    private String protocol = "https";
    private StringBuilder path;
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();

    public RestUriBuilder host(String host) {
        Preconditions.checkNotNull((Object)host);
        this.host = host;
        return this;
    }

    public RestUriBuilder protocol(String protocol) {
        Preconditions.checkNotNull((Object)protocol);
        this.protocol = protocol;
        return this;
    }

    public RestUriBuilder path(String path) {
        Preconditions.checkNotNull((Object)path);
        this.path = new StringBuilder();
        this.path.append(path);
        return this;
    }

    public RestUriBuilder appendPath(String path) {
        Preconditions.checkNotNull((Object)path);
        this.path.append(path);
        return this;
    }

    public RestUriBuilder addParameter(String key, Object value) {
        return this.addParameters(key, Collections.singletonList(value));
    }

    public RestUriBuilder addParameters(String key, Collection<?> value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull(value);
        Iterable stringValues = Iterables.transform(value, (Function)new Function<Object, String>(){

            public String apply(Object o) {
                return String.valueOf(o);
            }
        });
        this.parameters.put(key, Lists.newArrayList((Iterable)stringValues));
        return this;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.protocol);
        builder.append("://");
        Preconditions.checkNotNull((Object)this.host);
        Preconditions.checkNotNull((Object)this.path);
        builder.append(this.host);
        builder.append((CharSequence)this.path);
        if (!this.parameters.isEmpty()) {
            builder.append("?");
            Joiner.on((String)"&").appendTo(builder, Iterables.transform(this.parameters.entrySet(), (Function)new Function<Map.Entry<String, List<String>>, String>(){

                public String apply(final Map.Entry<String, List<String>> stringStringEntry) {
                    return Joiner.on((String)"&").join((Iterable)Lists.transform(stringStringEntry.getValue(), (Function)new Function<String, String>(){

                        public String apply(String s) {
                            return (String)stringStringEntry.getKey() + "=" + s;
                        }
                    }));
                }
            }));
        }
        return builder.toString();
    }
}

