/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.lexoffice.java.sdk;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.focus_shift.lexoffice.java.sdk.LexofficeApiBuilder;
import de.focus_shift.lexoffice.java.sdk.RestUriBuilder;
import java.util.Arrays;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RequestContext {
    private static long lastCall;
    private final LexofficeApiBuilder apiBuilder;
    private HttpClient httpClient;
    private ClientHttpRequestFactory requestFactory;
    private RestTemplate restTemplate;
    private long throttlePeriod = 510L;

    RequestContext(LexofficeApiBuilder apiBuilder) {
        this.apiBuilder = apiBuilder;
        this.httpClient = HttpClientBuilder.create().build();
        this.requestFactory = new HttpComponentsClientHttpRequestFactory(this.httpClient);
        this.restTemplate = new RestTemplate(this.requestFactory);
        this.restTemplate.setMessageConverters(Arrays.asList(new MappingJackson2HttpMessageConverter(this.getObjectMapper())));
    }

    protected ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public RestUriBuilder getUriBuilder() {
        return new RestUriBuilder().protocol("https").host(this.apiBuilder.getHost());
    }

    public synchronized <R> R execute(RestUriBuilder uriBuilder, HttpMethod method, ParameterizedTypeReference<R> responseType) {
        return this.execute(uriBuilder, method, null, responseType);
    }

    public synchronized <R, E> R execute(RestUriBuilder uriBuilder, HttpMethod method, E body, ParameterizedTypeReference<R> responseType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.add("Authorization", "Bearer " + this.apiBuilder.getApiToken());
        this.checkThrottlePeriod();
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(), method, requestEntity, responseType, new Object[0]);
        lastCall = System.currentTimeMillis();
        if (this.apiBuilder.throttleProviderPresent()) {
            this.apiBuilder.getThrottleProvider().apiCalled();
        }
        return (R)response.getBody();
    }

    public synchronized void delete(RestUriBuilder uriBuilder) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.add("Authorization", "Bearer " + this.apiBuilder.getApiToken());
        this.checkThrottlePeriod();
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        this.restTemplate.exchange(uriBuilder.build(), HttpMethod.DELETE, request, Void.class, new Object[0]);
        lastCall = System.currentTimeMillis();
        if (this.apiBuilder.throttleProviderPresent()) {
            this.apiBuilder.getThrottleProvider().apiCalled();
        }
    }

    protected synchronized void checkThrottlePeriod() {
        if (this.apiBuilder.throttleProviderPresent()) {
            this.waitFuturePassed(this.apiBuilder.getThrottleProvider().getNextCallAllowed());
        } else {
            this.waitFuturePassed(lastCall + this.throttlePeriod);
        }
    }

    protected synchronized void waitFuturePassed(long future) {
        while (future > System.currentTimeMillis()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

