/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.lexoffice.java.sdk;

import de.focus_shift.lexoffice.java.sdk.LexofficeApi;
import de.focus_shift.lexoffice.java.sdk.RequestContext;

public class LexofficeApiBuilder {
    public static final String LEXOFFICE_API = "api.lexoffice.io/v1";
    private String host = "api.lexoffice.io/v1";
    private String apiToken = null;
    private ThrottleProvider throttleProvider;

    public LexofficeApiBuilder apiToken(String apiToken) {
        this.apiToken = apiToken;
        return this;
    }

    public LexofficeApiBuilder throttleProvider(ThrottleProvider throttleProvider) {
        this.throttleProvider = throttleProvider;
        return this;
    }

    public LexofficeApi build() {
        RequestContext context = new RequestContext(this);
        return new LexofficeApi(context);
    }

    boolean throttleProviderPresent() {
        return this.throttleProvider != null;
    }

    String getHost() {
        return this.host;
    }

    String getApiToken() {
        return this.apiToken;
    }

    ThrottleProvider getThrottleProvider() {
        return this.throttleProvider;
    }

    public static interface ThrottleProvider {
        public long getNextCallAllowed();

        public void apiCalled();
    }
}

