/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.launchpad.core;

import de.focus_shift.launchpad.api.HasLaunchpad;
import de.focus_shift.launchpad.core.AppDto;
import de.focus_shift.launchpad.core.Launchpad;
import de.focus_shift.launchpad.core.LaunchpadDto;
import de.focus_shift.launchpad.core.LaunchpadService;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ModelAttribute;

@ControllerAdvice(assignableTypes={HasLaunchpad.class})
public class LaunchpadControllerAdvice {
    private final LaunchpadService launchpadService;

    LaunchpadControllerAdvice(LaunchpadService launchpadService) {
        this.launchpadService = launchpadService;
    }

    @ModelAttribute
    public void addAttributes(Model model, Locale locale, Authentication authentication) {
        Launchpad launchpad = this.launchpadService.getLaunchpad(authentication);
        List<AppDto> appDtos = launchpad.getApps().stream().map(app -> new AppDto(app.getUrl().toString(), app.getAppName().get(locale), app.getIcon())).collect(Collectors.toList());
        if (!appDtos.isEmpty()) {
            model.addAttribute("launchpad", (Object)new LaunchpadDto(appDtos));
        }
    }
}

