/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.launchpad.core;

import de.focus_shift.launchpad.api.LaunchpadAppUrlCustomizer;
import de.focus_shift.launchpad.core.LaunchpadConfigProperties;
import de.focus_shift.launchpad.core.LaunchpadControllerAdvice;
import de.focus_shift.launchpad.core.LaunchpadService;
import de.focus_shift.launchpad.core.LaunchpadServiceImpl;
import java.net.URL;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@EnableConfigurationProperties(value={LaunchpadConfigProperties.class})
@ConditionalOnProperty(prefix="launchpad", name={"name-default-locale"})
public class LaunchpadAutoConfiguration {

    static class LaunchpadAppsCondition
    extends SpringBootCondition {
        private static final Bindable<List<LaunchpadConfigProperties.App>> APP_LIST = Bindable.listOf(LaunchpadConfigProperties.App.class);
        private static final String PROPERTY_NAME = "launchpad.apps";

        LaunchpadAppsCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            BindResult property = Binder.get((Environment)context.getEnvironment()).bind(PROPERTY_NAME, APP_LIST);
            ConditionMessage.Builder messageBuilder = ConditionMessage.forCondition((String)"apps", (Object[])new Object[0]);
            if (property.isBound()) {
                return ConditionOutcome.match((ConditionMessage)messageBuilder.found("property").items(new Object[]{PROPERTY_NAME}));
            }
            return ConditionOutcome.noMatch((ConditionMessage)messageBuilder.didNotFind("property").items(new Object[]{PROPERTY_NAME}));
        }
    }

    @Conditional(value={LaunchpadAppsCondition.class})
    static class LaunchpadConfig {
        LaunchpadConfig() {
        }

        @Bean
        LaunchpadControllerAdvice launchpadControllerAdvice(LaunchpadService launchpadService) {
            return new LaunchpadControllerAdvice(launchpadService);
        }

        @Bean
        LaunchpadService launchpadService(LaunchpadConfigProperties launchpadConfigProperties, LaunchpadAppUrlCustomizer appUrlCustomizer) {
            return new LaunchpadServiceImpl(launchpadConfigProperties, appUrlCustomizer);
        }

        @Bean
        @ConditionalOnMissingBean
        LaunchpadAppUrlCustomizer appUrlCustomizer() {
            return URL::new;
        }
    }
}

