/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.launchpad.core;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class AppName {
    private final String defaultName;
    private final Map<Locale, String> names;

    AppName(String defaultName, Map<Locale, String> names) {
        this.defaultName = defaultName;
        this.names = names;
    }

    public String get(Locale locale) {
        return this.names.getOrDefault(locale, this.defaultName);
    }

    public String toString() {
        return "AppName{defaultName='" + this.defaultName + "', names=" + String.valueOf(this.names) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppName appName = (AppName)o;
        return Objects.equals(this.defaultName, appName.defaultName) && Objects.equals(this.names, appName.names);
    }

    public int hashCode() {
        return Objects.hash(this.defaultName, this.names);
    }
}

