/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.parser.functions;

import java.time.LocalDate;
import java.time.Month;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.function.IntFunction;
import java.util.stream.Stream;

public class CalculateRelativeDatesFromChronologyWithinGregorianYear
implements IntFunction<Stream<LocalDate>> {
    private final int targetMonth;
    private final int targetDay;
    private final Chronology targetChrono;
    private final int relativeShift;

    public CalculateRelativeDatesFromChronologyWithinGregorianYear(int targetMonth, int targetDay, Chronology targetChrono, int relativeShift) {
        this.targetMonth = targetMonth;
        this.targetDay = targetDay;
        this.targetChrono = targetChrono;
        this.relativeShift = relativeShift;
    }

    @Override
    public Stream<LocalDate> apply(int gregorianYear) {
        int absoluteShift = Math.abs(this.relativeShift);
        LocalDate firstGregorianDate = LocalDate.of(gregorianYear, Month.JANUARY, 1);
        LocalDate lastGregorianDate = LocalDate.of(gregorianYear, Month.DECEMBER, 31);
        ChronoLocalDate firstTargetDate = this.targetChrono.date(firstGregorianDate.minusDays(absoluteShift));
        ChronoLocalDate lastTargetDate = this.targetChrono.date(lastGregorianDate.plusDays(absoluteShift));
        int lastYear = lastTargetDate.get(ChronoField.YEAR);
        Stream.Builder<LocalDate> builder = Stream.builder();
        for (int targetYear = firstTargetDate.get(ChronoField.YEAR); targetYear <= lastYear; ++targetYear) {
            ChronoLocalDate date = this.targetChrono.date(targetYear, this.targetMonth, this.targetDay).plus(this.relativeShift, ChronoUnit.DAYS);
            if (firstGregorianDate.isAfter(date) || lastGregorianDate.isBefore(date)) continue;
            builder.accept(LocalDate.from(date));
        }
        return builder.build();
    }
}

