/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.parser.impl;

import de.focus_shift.Holiday;
import de.focus_shift.parser.HolidayParser;
import de.focus_shift.parser.functions.CreateHoliday;
import de.focus_shift.parser.functions.FixedToLocalDate;
import de.focus_shift.parser.predicates.ValidLimitation;
import de.focus_shift.spi.Described;
import de.focus_shift.spi.Holidays;
import de.focus_shift.spi.Relation;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.stream.Collectors;

public class RelativeToFixedParser
implements HolidayParser {
    @Override
    public List<Holiday> parse(int year, Holidays holidays) {
        return holidays.relativeToFixed().stream().filter(new ValidLimitation(year)).map(rf -> {
            LocalDate fixed = new FixedToLocalDate(year).apply(rf.date());
            if (rf.weekday() != null) {
                DayOfWeek day = rf.weekday();
                int direction = rf.when() == Relation.BEFORE ? -1 : 1;
                fixed = fixed.plusDays(direction);
                while (fixed.getDayOfWeek() != day) {
                    fixed = fixed.plusDays(direction);
                }
            } else if (rf.days() != null) {
                fixed = fixed.plus((TemporalAmount)(rf.when() == Relation.BEFORE ? rf.days().negated() : rf.days()));
            }
            return new CreateHoliday(fixed).apply((Described)rf);
        }).collect(Collectors.toList());
    }
}

