/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.parser.impl;

import de.focus_shift.Holiday;
import de.focus_shift.parser.HolidayParser;
import de.focus_shift.parser.functions.CalculateRelativeDatesFromChronologyWithinGregorianYear;
import de.focus_shift.parser.functions.CreateHoliday;
import de.focus_shift.parser.predicates.ValidLimitation;
import de.focus_shift.spi.Described;
import de.focus_shift.spi.Holidays;
import java.time.LocalDate;
import java.time.chrono.Chronology;
import java.util.List;
import java.util.stream.Collectors;
import org.threeten.extra.chrono.CopticChronology;

public class EthiopianOrthodoxHolidayParser
implements HolidayParser {
    @Override
    public List<Holiday> parse(int year, Holidays holidays) {
        return holidays.ethiopianOrthodoxHolidays().stream().filter(new ValidLimitation(year)).flatMap(eoh -> {
            Object ethiopianHolidays;
            switch (eoh.type()) {
                case TIMKAT: {
                    ethiopianHolidays = new CalculateRelativeDatesFromChronologyWithinGregorianYear(5, 10, (Chronology)CopticChronology.INSTANCE, 0).apply(year);
                    break;
                }
                case ENKUTATASH: {
                    ethiopianHolidays = new CalculateRelativeDatesFromChronologyWithinGregorianYear(1, 1, (Chronology)CopticChronology.INSTANCE, 0).apply(year);
                    break;
                }
                case MESKEL: {
                    ethiopianHolidays = new CalculateRelativeDatesFromChronologyWithinGregorianYear(1, 17, (Chronology)CopticChronology.INSTANCE, 0).apply(year);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ethiopian orthodox holiday type " + eoh.type());
                }
            }
            return ethiopianHolidays.map(date -> new CreateHoliday((LocalDate)date).apply((Described)eoh));
        }).collect(Collectors.toList());
    }
}

