/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core;

import de.focus_shift.jollyday.core.CalendarHierarchy;
import de.focus_shift.jollyday.core.Holiday;
import de.focus_shift.jollyday.core.HolidayCalendar;
import de.focus_shift.jollyday.core.HolidayType;
import de.focus_shift.jollyday.core.ManagerParameter;
import de.focus_shift.jollyday.core.ManagerParameters;
import de.focus_shift.jollyday.core.caching.Cache;
import de.focus_shift.jollyday.core.caching.HolidayManagerValueHandler;
import de.focus_shift.jollyday.core.configuration.ConfigurationProviderManager;
import de.focus_shift.jollyday.core.datasource.ConfigurationServiceManager;
import de.focus_shift.jollyday.core.parser.functions.CalendarToLocalDate;
import de.focus_shift.jollyday.core.spi.ConfigurationService;
import de.focus_shift.jollyday.core.support.LazyServiceLoaderCache;
import de.focus_shift.jollyday.core.util.CalendarUtil;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HolidayManager {
    private static final Logger LOG = LoggerFactory.getLogger(HolidayManager.class);
    private static boolean cachingEnabled = true;
    private static final Cache<HolidayManager> HOLIDAY_MANAGER_CACHE = new Cache();
    private static final ConfigurationProviderManager CONFIGURATION_MANAGER_PROVIDER = new ConfigurationProviderManager();
    private static final ConfigurationServiceManager configurationServiceManager = new ConfigurationServiceManager(new LazyServiceLoaderCache<ConfigurationService>(ConfigurationService.class));
    private final Cache<Set<Holiday>> holidayCache = new Cache();
    private ConfigurationService configurationService;
    private ManagerParameter managerParameter;

    public void init(ManagerParameter parameters) {
        this.managerParameter = parameters;
        this.doInit();
    }

    public abstract void doInit();

    public static HolidayManager getInstance() {
        return HolidayManager.getInstance(ManagerParameters.create((String)null, null));
    }

    public static HolidayManager getInstance(Properties properties) {
        return HolidayManager.getInstance(ManagerParameters.create((String)null, properties));
    }

    public static HolidayManager getInstance(ManagerParameter parameter) {
        return HolidayManager.createManager(parameter);
    }

    private static HolidayManager createManager(ManagerParameter parameter) {
        LOG.debug("Creating HolidayManager for calendar '{}'. Caching enabled: {}", (Object)parameter, (Object)HolidayManager.isManagerCachingEnabled());
        CONFIGURATION_MANAGER_PROVIDER.mergeConfigurationProperties(parameter);
        String managerImplClassName = HolidayManager.readManagerImplClassName(parameter);
        HolidayManagerValueHandler holidayManagerValueHandler = new HolidayManagerValueHandler(parameter, managerImplClassName, configurationServiceManager);
        if (HolidayManager.isManagerCachingEnabled()) {
            return HOLIDAY_MANAGER_CACHE.get(holidayManagerValueHandler);
        }
        return holidayManagerValueHandler.createValue();
    }

    private static String readManagerImplClassName(ManagerParameter parameter) {
        String className = parameter.getManagerImplClassName();
        if (className == null) {
            throw new IllegalStateException("Missing configuration 'manager.impl'. Cannot create manager.");
        }
        return className;
    }

    public static void setManagerCachingEnabled(boolean managerCachingEnabled) {
        cachingEnabled = managerCachingEnabled;
    }

    public static boolean isManagerCachingEnabled() {
        return cachingEnabled;
    }

    public static void clearManagerCache() {
        HOLIDAY_MANAGER_CACHE.clear();
    }

    public boolean isHoliday(Calendar calendar, String ... args) {
        return this.isHoliday(calendar, (HolidayType)null, args);
    }

    public boolean isHoliday(Calendar calendar, HolidayType holidayType, String ... args) {
        return this.isHoliday(new CalendarToLocalDate().apply(calendar), holidayType, args);
    }

    public boolean isHoliday(LocalDate localDate, String ... args) {
        return this.isHoliday(localDate, (HolidayType)null, args);
    }

    public boolean isHoliday(final LocalDate localDate, HolidayType holidayType, final String ... args) {
        final StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(localDate.getYear());
        for (String arg : args) {
            keyBuilder.append("_");
            keyBuilder.append(arg);
        }
        Cache.ValueHandler<Set<Holiday>> valueHandler = new Cache.ValueHandler<Set<Holiday>>(){

            @Override
            public String getKey() {
                return keyBuilder.toString();
            }

            @Override
            public Set<Holiday> createValue() {
                return HolidayManager.this.getHolidays(localDate.getYear(), args);
            }
        };
        Set<Holiday> holidays = this.holidayCache.get(valueHandler);
        return CalendarUtil.contains(holidays, localDate, holidayType);
    }

    public static Set<String> getSupportedCalendarCodes() {
        return Arrays.stream(HolidayCalendar.values()).map(HolidayCalendar::getId).collect(Collectors.toUnmodifiableSet());
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public ManagerParameter getManagerParameter() {
        return this.managerParameter;
    }

    public abstract Set<Holiday> getHolidays(int var1, String ... var2);

    public abstract Set<Holiday> getHolidays(LocalDate var1, LocalDate var2, String ... var3);

    public abstract CalendarHierarchy getCalendarHierarchy();
}

