/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.util;

import de.focus_shift.jollyday.core.Holiday;
import de.focus_shift.jollyday.core.HolidayType;
import de.focus_shift.jollyday.core.parser.functions.CalculateRelativeDatesFromChronologyWithinGregorianYear;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.HijrahChronology;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.threeten.extra.chrono.CopticChronology;

public class CalendarUtil {
    public LocalDate create() {
        return LocalDate.now();
    }

    public LocalDate create(int year, int month, int day) {
        return LocalDate.of(year, month, day);
    }

    public ChronoLocalDate create(int year, int month, int day, Chronology chronology) {
        return chronology.date(year, month, day);
    }

    public boolean isWeekend(LocalDate date) {
        return date.getDayOfWeek() == DayOfWeek.SATURDAY || date.getDayOfWeek() == DayOfWeek.SUNDAY;
    }

    public Stream<LocalDate> getIslamicHolidaysInGregorianYear(int gregorianYear, int islamicMonth, int islamicDay) {
        return this.getDatesFromChronologyWithinGregorianYear(islamicMonth, islamicDay, gregorianYear, HijrahChronology.INSTANCE);
    }

    public Set<LocalDate> getRelativeIslamicHolidaysInGregorianYear(int gregorianYear, int islamicMonth, int islamicDay, int relativeShift) {
        return this.getRelativeDatesFromChronologyWithinGregorianYear(islamicMonth, islamicDay, gregorianYear, HijrahChronology.INSTANCE, relativeShift);
    }

    public Stream<LocalDate> getEthiopianOrthodoxHolidaysInGregorianYear(int gregorianYear, int eoMonth, int eoDay) {
        return this.getDatesFromChronologyWithinGregorianYear(eoMonth, eoDay, gregorianYear, (Chronology)CopticChronology.INSTANCE);
    }

    private Stream<LocalDate> getDatesFromChronologyWithinGregorianYear(int targetMonth, int targetDay, int gregorianYear, Chronology targetChrono) {
        return new CalculateRelativeDatesFromChronologyWithinGregorianYear(targetMonth, targetDay, targetChrono, 0).apply(gregorianYear);
    }

    private Set<LocalDate> getRelativeDatesFromChronologyWithinGregorianYear(int targetMonth, int targetDay, int gregorianYear, Chronology targetChrono, int relativeShift) {
        int absoluteShift = Math.abs(relativeShift);
        HashSet<LocalDate> holidays = new HashSet<LocalDate>();
        LocalDate firstGregorianDate = LocalDate.of(gregorianYear, Month.JANUARY, 1);
        LocalDate lastGregorianDate = LocalDate.of(gregorianYear, Month.DECEMBER, 31);
        ChronoLocalDate firstTargetDate = targetChrono.date(firstGregorianDate.minusDays(absoluteShift));
        ChronoLocalDate lastTargetDate = targetChrono.date(lastGregorianDate.plusDays(absoluteShift));
        int lastYear = lastTargetDate.get(ChronoField.YEAR);
        for (int targetYear = firstTargetDate.get(ChronoField.YEAR); targetYear <= lastYear; ++targetYear) {
            ChronoLocalDate d = targetChrono.date(targetYear, targetMonth, targetDay).plus(relativeShift, ChronoUnit.DAYS);
            if (firstGregorianDate.isAfter(d) || lastGregorianDate.isBefore(d)) continue;
            holidays.add(LocalDate.from(d));
        }
        return holidays;
    }

    public boolean contains(Set<Holiday> holidays, LocalDate date, HolidayType holidayType) {
        return holidays.stream().anyMatch(h -> h.getDate().equals(date) && (holidayType == null || h.getType() == holidayType));
    }

    public boolean contains(Set<Holiday> holidays, LocalDate date) {
        return this.contains(holidays, date, null);
    }
}

