/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.configuration.impl;

import de.focus_shift.jollyday.core.configuration.ConfigurationProvider;
import de.focus_shift.jollyday.core.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConfigurationProvider.class);
    private static final String CONFIG_FILE = "jollyday.properties";
    private final ResourceUtil resourceUtil = new ResourceUtil();

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        try {
            URL config = this.resourceUtil.getResource(CONFIG_FILE);
            if (config == null) {
                throw new IllegalStateException("Properties file jollyday.properties not found on classpath.");
            }
            try (InputStream stream = config.openStream();){
                if (stream != null) {
                    properties.load(stream);
                } else {
                    LOG.warn("Could not load default properties file '{}' from classpath.", (Object)CONFIG_FILE);
                }
            }
            return properties;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load default properties from classpath.", e);
        }
    }
}

