/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.configuration;

import de.focus_shift.jollyday.core.ManagerParameter;
import de.focus_shift.jollyday.core.configuration.ConfigurationProvider;
import de.focus_shift.jollyday.core.configuration.impl.DefaultConfigurationProvider;
import de.focus_shift.jollyday.core.configuration.impl.URLConfigurationProvider;
import de.focus_shift.jollyday.core.util.ClassLoadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProviderManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationProviderManager.class);
    private ConfigurationProvider defaultConfigurationProvider = new DefaultConfigurationProvider();
    private ConfigurationProvider urlConfigurationProvider = new URLConfigurationProvider();
    private final ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    public void mergeConfigurationProperties(ManagerParameter parameter) {
        this.addInternalConfigurationProviderProperties(parameter);
        this.addCustomConfigurationProviderProperties(parameter);
    }

    private void addInternalConfigurationProviderProperties(ManagerParameter parameter) {
        parameter.mergeProperties(this.urlConfigurationProvider.getProperties());
        parameter.mergeProperties(this.defaultConfigurationProvider.getProperties());
    }

    private void addCustomConfigurationProviderProperties(ManagerParameter parameter) {
        String providersStrList = System.getProperty("config.providers");
        if (providersStrList != null) {
            String[] providersClassNames;
            for (String providerClassName : providersClassNames = providersStrList.split(",")) {
                if (providerClassName == null || "".equals(providerClassName)) continue;
                try {
                    Class<?> providerClass = Class.forName(providerClassName.trim(), true, this.classLoadingUtil.getClassloader());
                    ConfigurationProvider configurationProvider = (ConfigurationProvider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    parameter.mergeProperties(configurationProvider.getProperties());
                }
                catch (Exception e) {
                    LOG.warn("Cannot load configuration from provider class '{}'. {} ({}).", new Object[]{providerClassName, e.getClass().getSimpleName(), e.getMessage()});
                }
            }
        }
    }
}

