/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core;

import de.focus_shift.jollyday.core.HolidayCalendar;
import de.focus_shift.jollyday.core.ManagerParameter;
import de.focus_shift.jollyday.core.parameter.CalendarPartManagerParameter;
import de.focus_shift.jollyday.core.parameter.UrlManagerParameter;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;

public final class ManagerParameters {
    private ManagerParameters() {
    }

    public static ManagerParameter create(String calendarPart) {
        return ManagerParameters.create(calendarPart, null);
    }

    public static ManagerParameter create(Locale lc) {
        String calendarPart = "".equals(lc.getCountry()) ? lc.getLanguage() : lc.getCountry();
        return ManagerParameters.create(calendarPart, null);
    }

    public static ManagerParameter create(HolidayCalendar calendar) {
        return ManagerParameters.create(calendar, null);
    }

    public static ManagerParameter create(HolidayCalendar calendar, Properties properties) {
        return ManagerParameters.create(calendar.getId(), properties);
    }

    public static ManagerParameter create(URL calendarFileUrl) {
        return ManagerParameters.create(calendarFileUrl, null);
    }

    public static ManagerParameter create(String calendarPart, Properties properties) {
        return new CalendarPartManagerParameter(ManagerParameters.prepareCalendarName(calendarPart), properties);
    }

    public static ManagerParameter create(URL calendarFileUrl, Properties properties) {
        return new UrlManagerParameter(calendarFileUrl, properties);
    }

    private static String prepareCalendarName(String calendar) {
        if (calendar == null || "".equals(calendar.trim())) {
            return Locale.getDefault().getCountry().toLowerCase();
        }
        return calendar.trim().toLowerCase();
    }
}

